/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.redis.descriptor;

import org.apache.flink.table.descriptors.ConnectorDescriptorValidator;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.util.Preconditions;

public class Redis
extends ConnectorDescriptorValidator {
    private final DescriptorProperties properties = new DescriptorProperties();
    private String mode = null;
    private String redisCommand = null;
    private Integer ttl;

    public Redis(String type, int version) {
        this.properties.putString("connector.type", type);
        this.properties.putInt("connector.property-version", version);
    }

    public Redis() {
        this("redis", 1);
    }

    public Redis command(String redisCommand) {
        this.redisCommand = redisCommand;
        this.properties.putString("command", redisCommand);
        return this;
    }

    public Redis ttl(Integer ttl) {
        this.ttl = ttl;
        this.properties.putInt("key.ttl", ttl.intValue());
        return this;
    }

    public Redis mode(String mode) {
        this.mode = mode;
        this.properties.putString("redis-mode", mode);
        return this;
    }

    public Redis property(String k, String v) {
        this.properties.putString(k, v);
        return this;
    }

    public void validate() {
        Preconditions.checkArgument((boolean)this.properties.containsKey("command"), (Object)"need specified redis command");
        if (this.mode.equalsIgnoreCase("cluster")) {
            Preconditions.checkArgument((boolean)this.properties.containsKey("cluster-nodes"), (Object)"cluster mode need cluster-nodes info");
        } else if (this.mode.equalsIgnoreCase("sentinel")) {
            Preconditions.checkArgument((boolean)this.properties.containsKey("master.name"), (Object)"sentinel mode need master name");
            Preconditions.checkArgument((boolean)this.properties.containsKey("sentinel"), (Object)"sentinel mode need sentinel infos");
        }
    }
}

