/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.ldif.anonymizer;

import java.util.Map;
import java.util.Random;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.BinaryValue;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.ldif.anonymizer.AbstractAnonymizer;

public class BinaryAnonymizer
extends AbstractAnonymizer<byte[]> {
    Random random = new Random(System.currentTimeMillis());

    @Override
    public Attribute anonymize(Map<Value<byte[]>, Value<byte[]>> valueMap, Attribute attribute) {
        DefaultAttribute result = new DefaultAttribute(attribute.getAttributeType());
        this.random.setSeed(System.nanoTime());
        for (Value value : attribute) {
            if (value instanceof BinaryValue) {
                byte[] bytesValue = value.getBytes();
                int length = bytesValue.length;
                byte[] newValue = new byte[length];
                for (int i = 0; i < length; ++i) {
                    newValue[i] = (byte)(this.random.nextInt(25) + 65);
                }
                try {
                    result.add(new byte[][]{newValue});
                }
                catch (LdapInvalidAttributeValueException ldapInvalidAttributeValueException) {}
                continue;
            }
            byte[] byteValue = value.getBytes();
            byte[] newValue = new byte[byteValue.length];
            for (int i = 0; i < byteValue.length; ++i) {
                newValue[i] = (byte)this.random.nextInt();
            }
            try {
                result.add(new byte[][]{newValue});
            }
            catch (LdapInvalidAttributeValueException ldapInvalidAttributeValueException) {}
        }
        return result;
    }
}

