/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.protocol.shared.catalog;

import java.util.HashMap;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.filter.FilterParser;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.protocol.shared.store.DirectoryServiceOperation;

public class GetCatalog
implements DirectoryServiceOperation {
    @Override
    public Object execute(CoreSession session, Dn base) throws Exception {
        String filter = "(objectClass=apacheCatalogEntry)";
        EntryFilteringCursor list = session.search(Dn.ROOT_DSE, SearchScope.SUBTREE, FilterParser.parse((SchemaManager)session.getDirectoryService().getSchemaManager(), (String)filter), AliasDerefMode.DEREF_ALWAYS, new String[0]);
        HashMap<String, String> catalog = new HashMap<String, String>();
        list.beforeFirst();
        while (list.next()) {
            Entry result = (Entry)list.get();
            String name = null;
            Attribute attribute = result.get("apacheCatalogEntryName");
            if (attribute != null) {
                name = attribute.getString();
            }
            String basedn = null;
            attribute = result.get("apacheCatalogEntryBaseDn");
            if (attribute != null) {
                basedn = attribute.getString();
            }
            catalog.put(name, basedn);
        }
        return catalog;
    }
}

