/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.registry.confluent;

import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.specific.SpecificRecord;
import org.apache.flink.formats.avro.RegistryAvroDeserializationSchema;
import org.apache.flink.formats.avro.SchemaCoder;
import org.apache.flink.formats.avro.registry.confluent.ConfluentSchemaRegistryCoder;

public class ConfluentRegistryAvroDeserializationSchema<T>
extends RegistryAvroDeserializationSchema<T> {
    private static final int DEFAULT_IDENTITY_MAP_CAPACITY = 1000;
    private static final long serialVersionUID = -1671641202177852775L;

    private ConfluentRegistryAvroDeserializationSchema(Class<T> recordClazz, @Nullable Schema reader, SchemaCoder.SchemaCoderProvider schemaCoderProvider) {
        super(recordClazz, reader, schemaCoderProvider);
    }

    public static ConfluentRegistryAvroDeserializationSchema<GenericRecord> forGeneric(Schema schema, String url) {
        return ConfluentRegistryAvroDeserializationSchema.forGeneric(schema, url, 1000);
    }

    public static ConfluentRegistryAvroDeserializationSchema<GenericRecord> forGeneric(Schema schema, String url, int identityMapCapacity) {
        return new ConfluentRegistryAvroDeserializationSchema<GenericRecord>(GenericRecord.class, schema, new CachedSchemaCoderProvider(url, identityMapCapacity));
    }

    public static <T extends SpecificRecord> ConfluentRegistryAvroDeserializationSchema<T> forSpecific(Class<T> tClass, String url) {
        return ConfluentRegistryAvroDeserializationSchema.forSpecific(tClass, url, 1000);
    }

    public static <T extends SpecificRecord> ConfluentRegistryAvroDeserializationSchema<T> forSpecific(Class<T> tClass, String url, int identityMapCapacity) {
        return new ConfluentRegistryAvroDeserializationSchema<T>(tClass, null, new CachedSchemaCoderProvider(url, identityMapCapacity));
    }

    private static class CachedSchemaCoderProvider
    implements SchemaCoder.SchemaCoderProvider {
        private static final long serialVersionUID = 4023134423033312666L;
        private final String url;
        private final int identityMapCapacity;

        CachedSchemaCoderProvider(String url, int identityMapCapacity) {
            this.url = url;
            this.identityMapCapacity = identityMapCapacity;
        }

        public SchemaCoder get() {
            return new ConfluentSchemaRegistryCoder(new CachedSchemaRegistryClient(this.url, this.identityMapCapacity));
        }
    }
}

