/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.registry.confluent.shaded.org.101tec;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.flink.formats.avro.registry.confluent.shaded.org.101tec.Holder;
import org.apache.flink.formats.avro.registry.confluent.shaded.org.101tec.IZkDataListener;
import org.apache.flink.formats.avro.registry.confluent.shaded.org.101tec.ZkClient;
import org.apache.flink.formats.avro.registry.confluent.shaded.org.101tec.exception.ZkNoNodeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContentWatcher<T>
implements IZkDataListener {
    private static final Logger LOG = LoggerFactory.getLogger(ContentWatcher.class);
    private Lock _contentLock = new ReentrantLock(true);
    private Condition _contentAvailable = this._contentLock.newCondition();
    private Holder<T> _content;
    private String _fileName;
    private ZkClient _zkClient;

    public ContentWatcher(ZkClient zkClient, String fileName) {
        this._fileName = fileName;
        this._zkClient = zkClient;
    }

    public void start() {
        this._zkClient.subscribeDataChanges(this._fileName, this);
        this.readData();
        LOG.debug("Started ContentWatcher");
    }

    private void readData() {
        try {
            this.setContent(this._zkClient.readData(this._fileName));
        }
        catch (ZkNoNodeException zkNoNodeException) {
            // empty catch block
        }
    }

    public void stop() {
        this._zkClient.unsubscribeDataChanges(this._fileName, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContent(T data) {
        LOG.debug("Received new data: " + data);
        this._contentLock.lock();
        try {
            this._content = new Holder<T>(data);
            this._contentAvailable.signalAll();
        }
        finally {
            this._contentLock.unlock();
        }
    }

    @Override
    public void handleDataChange(String dataPath, Object data) {
        this.setContent(data);
    }

    @Override
    public void handleDataDeleted(String dataPath) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getContent() throws InterruptedException {
        this._contentLock.lock();
        try {
            while (this._content == null) {
                this._contentAvailable.await();
            }
            T t = this._content.get();
            return t;
        }
        finally {
            this._contentLock.unlock();
        }
    }
}

