/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.table;

import java.time.Duration;
import java.util.List;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.InlineElement;
import org.apache.flink.configuration.description.TextElement;

@PublicEvolving
public class ElasticsearchConnectorOptions {
    public static final ConfigOption<List<String>> HOSTS_OPTION = ConfigOptions.key((String)"hosts").stringType().asList().noDefaultValue().withDescription("Elasticsearch hosts to connect to.");
    public static final ConfigOption<String> INDEX_OPTION = ConfigOptions.key((String)"index").stringType().noDefaultValue().withDescription("Elasticsearch index for every record.");
    public static final ConfigOption<String> DOCUMENT_TYPE_OPTION = ConfigOptions.key((String)"document-type").stringType().noDefaultValue().withDescription("Elasticsearch document type.");
    public static final ConfigOption<String> PASSWORD_OPTION = ConfigOptions.key((String)"password").stringType().noDefaultValue().withDescription("Password used to connect to Elasticsearch instance.");
    public static final ConfigOption<String> USERNAME_OPTION = ConfigOptions.key((String)"username").stringType().noDefaultValue().withDescription("Username used to connect to Elasticsearch instance.");
    public static final ConfigOption<String> KEY_DELIMITER_OPTION = ConfigOptions.key((String)"document-id.key-delimiter").stringType().defaultValue((Object)"_").withDescription("Delimiter for composite keys e.g., \"$\" would result in IDs \"KEY1$KEY2$KEY3\".");
    public static final ConfigOption<String> FAILURE_HANDLER_OPTION = ConfigOptions.key((String)"failure-handler").stringType().defaultValue((Object)"fail").withDescription(Description.builder().text("Failure handling strategy in case a request to Elasticsearch fails").list(new InlineElement[]{TextElement.text((String)"\"fail\" (throws an exception if a request fails and thus causes a job failure)"), TextElement.text((String)"\"ignore\" (ignores failures and drops the request)"), TextElement.text((String)"\"retry-rejected\" (re-adds requests that have failed due to queue capacity saturation)"), TextElement.text((String)"\"class name\" for failure handling with a ActionRequestFailureHandler subclass")}).build());
    public static final ConfigOption<Boolean> FLUSH_ON_CHECKPOINT_OPTION = ConfigOptions.key((String)"sink.flush-on-checkpoint").booleanType().defaultValue((Object)true).withDescription("Disables flushing on checkpoint");
    public static final ConfigOption<Integer> BULK_FLUSH_MAX_ACTIONS_OPTION = ConfigOptions.key((String)"sink.bulk-flush.max-actions").intType().defaultValue((Object)1000).withDescription("Maximum number of actions to buffer for each bulk request.");
    public static final ConfigOption<MemorySize> BULK_FLASH_MAX_SIZE_OPTION = ConfigOptions.key((String)"sink.bulk-flush.max-size").memoryType().defaultValue((Object)MemorySize.parse((String)"2mb")).withDescription("Maximum size of buffered actions per bulk request");
    public static final ConfigOption<Duration> BULK_FLUSH_INTERVAL_OPTION = ConfigOptions.key((String)"sink.bulk-flush.interval").durationType().defaultValue((Object)Duration.ofSeconds(1L)).withDescription("Bulk flush interval");
    public static final ConfigOption<BackOffType> BULK_FLUSH_BACKOFF_TYPE_OPTION = ConfigOptions.key((String)"sink.bulk-flush.backoff.strategy").enumType(BackOffType.class).defaultValue((Object)BackOffType.DISABLED).withDescription("Backoff strategy");
    public static final ConfigOption<Integer> BULK_FLUSH_BACKOFF_MAX_RETRIES_OPTION = ConfigOptions.key((String)"sink.bulk-flush.backoff.max-retries").intType().noDefaultValue().withDescription("Maximum number of retries.");
    public static final ConfigOption<Duration> BULK_FLUSH_BACKOFF_DELAY_OPTION = ConfigOptions.key((String)"sink.bulk-flush.backoff.delay").durationType().noDefaultValue().withDescription("Delay between each backoff attempt.");
    public static final ConfigOption<Duration> CONNECTION_MAX_RETRY_TIMEOUT_OPTION = ConfigOptions.key((String)"connection.max-retry-timeout").durationType().noDefaultValue().withDescription("Maximum timeout between retries.");
    public static final ConfigOption<String> CONNECTION_PATH_PREFIX = ConfigOptions.key((String)"connection.path-prefix").stringType().noDefaultValue().withDescription("Prefix string to be added to every REST communication.");
    public static final ConfigOption<String> FORMAT_OPTION = ConfigOptions.key((String)"format").stringType().defaultValue((Object)"json").withDescription("The format must produce a valid JSON document. Please refer to the documentation on formats for more details.");

    private ElasticsearchConnectorOptions() {
    }

    public static enum BackOffType {
        DISABLED,
        CONSTANT,
        EXPONENTIAL;

    }
}

