/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.util.Map;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.FormatDescriptor;
import org.apache.flink.table.utils.TypeStringUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class Csv
extends FormatDescriptor {
    private DescriptorProperties internalProperties = new DescriptorProperties(true);

    public Csv() {
        super("csv", 1);
    }

    public Csv fieldDelimiter(char delimiter) {
        this.internalProperties.putCharacter("format.field-delimiter", delimiter);
        return this;
    }

    public Csv lineDelimiter(String delimiter) {
        Preconditions.checkNotNull((Object)delimiter);
        this.internalProperties.putString("format.line-delimiter", delimiter);
        return this;
    }

    public Csv quoteCharacter(char quoteCharacter) {
        this.internalProperties.putCharacter("format.quote-character", quoteCharacter);
        return this;
    }

    public Csv allowComments() {
        this.internalProperties.putBoolean("format.allow-comments", true);
        return this;
    }

    public Csv ignoreParseErrors() {
        this.internalProperties.putBoolean("format.ignore-parse-errors", true);
        return this;
    }

    public Csv arrayElementDelimiter(String delimiter) {
        Preconditions.checkNotNull((Object)delimiter);
        this.internalProperties.putString("format.array-element-delimiter", delimiter);
        return this;
    }

    public Csv escapeCharacter(char escapeCharacter) {
        this.internalProperties.putCharacter("format.escape-character", escapeCharacter);
        return this;
    }

    public Csv nullLiteral(String nullLiteral) {
        Preconditions.checkNotNull((Object)nullLiteral);
        this.internalProperties.putString("format.null-literal", nullLiteral);
        return this;
    }

    public Csv schema(TypeInformation<Row> schemaType) {
        Preconditions.checkNotNull(schemaType);
        this.internalProperties.putString("format.schema", TypeStringUtils.writeTypeInfo(schemaType));
        return this;
    }

    @Deprecated
    public Csv deriveSchema() {
        this.internalProperties.putBoolean("format.derive-schema", true);
        return this;
    }

    protected Map<String, String> toFormatProperties() {
        DescriptorProperties properties = new DescriptorProperties();
        properties.putProperties(this.internalProperties);
        return properties.asMap();
    }
}

