/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.scala.FlinkILoop;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.WritableConfig;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.util.JarUtils;
import org.apache.flink.util.Preconditions;

@Internal
public class ScalaShellStreamEnvironment
extends StreamExecutionEnvironment {
    private final List<URL> jarFiles;
    private final FlinkILoop flinkILoop;

    public ScalaShellStreamEnvironment(Configuration configuration, FlinkILoop flinkILoop, String ... jarFiles) {
        super(ScalaShellStreamEnvironment.validateAndGetConfiguration(configuration));
        this.flinkILoop = (FlinkILoop)((Object)Preconditions.checkNotNull((Object)((Object)flinkILoop)));
        this.jarFiles = (List)Preconditions.checkNotNull((Object)JarUtils.getJarFiles((String[])jarFiles));
    }

    private static Configuration validateAndGetConfiguration(Configuration configuration) {
        if (!ExecutionEnvironment.areExplicitEnvironmentsAllowed()) {
            throw new InvalidProgramException("The RemoteEnvironment cannot be used when submitting a program through a client, or running in a TestEnvironment context.");
        }
        return (Configuration)Preconditions.checkNotNull((Object)configuration);
    }

    public JobClient executeAsync(StreamGraph streamGraph) throws Exception {
        this.updateDependencies();
        return super.executeAsync(streamGraph);
    }

    private void updateDependencies() throws Exception {
        Preconditions.checkState((boolean)this.configuration.getBoolean(DeploymentOptions.ATTACHED), (Object)"Only ATTACHED mode is supported by the scala shell.");
        List<URL> updatedJarFiles = this.getUpdatedJarFiles();
        ConfigUtils.encodeCollectionToConfig((WritableConfig)this.configuration, (ConfigOption)PipelineOptions.JARS, updatedJarFiles, URL::toString);
    }

    public Configuration getClientConfiguration() {
        return this.configuration;
    }

    private List<URL> getUpdatedJarFiles() throws MalformedURLException {
        URL jarUrl = this.flinkILoop.writeFilesToDisk().getAbsoluteFile().toURI().toURL();
        ArrayList<URL> allJarFiles = new ArrayList<URL>(this.jarFiles);
        allJarFiles.add(jarUrl);
        return allJarFiles;
    }

    public static void disableAllContextAndOtherEnvironments() {
        ScalaShellStreamEnvironment.initializeContextEnvironment(configuration -> {
            throw new UnsupportedOperationException("Execution Environment is already defined for this shell.");
        });
    }

    public static void resetContextEnvironments() {
        StreamExecutionEnvironment.resetContextEnvironment();
    }
}

