/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.message.AlterPartitionReassignmentsRequestData;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.message.AlterPartitionReassignmentsResponseData;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AlterPartitionReassignmentsResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.ApiError;

public class AlterPartitionReassignmentsRequest
extends AbstractRequest {
    private final AlterPartitionReassignmentsRequestData data;
    private final short version;

    private AlterPartitionReassignmentsRequest(AlterPartitionReassignmentsRequestData data, short version) {
        super(ApiKeys.ALTER_PARTITION_REASSIGNMENTS, version);
        this.data = data;
        this.version = version;
    }

    AlterPartitionReassignmentsRequest(Struct struct, short version) {
        super(ApiKeys.ALTER_PARTITION_REASSIGNMENTS, version);
        this.data = new AlterPartitionReassignmentsRequestData(struct, version);
        this.version = version;
    }

    public static AlterPartitionReassignmentsRequest parse(ByteBuffer buffer, short version) {
        return new AlterPartitionReassignmentsRequest(ApiKeys.ALTER_PARTITION_REASSIGNMENTS.parseRequest(version, buffer), version);
    }

    public AlterPartitionReassignmentsRequestData data() {
        return this.data;
    }

    @Override
    public Struct toStruct() {
        return this.data.toStruct(this.version);
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ApiError apiError = ApiError.fromThrowable(e);
        ArrayList<AlterPartitionReassignmentsResponseData.ReassignableTopicResponse> topicResponses = new ArrayList<AlterPartitionReassignmentsResponseData.ReassignableTopicResponse>();
        for (AlterPartitionReassignmentsRequestData.ReassignableTopic topic : this.data.topics()) {
            List<AlterPartitionReassignmentsResponseData.ReassignablePartitionResponse> partitionResponses = topic.partitions().stream().map(partition -> new AlterPartitionReassignmentsResponseData.ReassignablePartitionResponse().setPartitionIndex(partition.partitionIndex()).setErrorCode(apiError.error().code()).setErrorMessage(apiError.message())).collect(Collectors.toList());
            topicResponses.add(new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName(topic.name()).setPartitions(partitionResponses));
        }
        AlterPartitionReassignmentsResponseData responseData = new AlterPartitionReassignmentsResponseData().setResponses(topicResponses).setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()).setThrottleTimeMs(throttleTimeMs);
        return new AlterPartitionReassignmentsResponse(responseData);
    }

    public static class Builder
    extends AbstractRequest.Builder<AlterPartitionReassignmentsRequest> {
        private final AlterPartitionReassignmentsRequestData data;

        public Builder(AlterPartitionReassignmentsRequestData data) {
            super(ApiKeys.ALTER_PARTITION_REASSIGNMENTS);
            this.data = data;
        }

        @Override
        public AlterPartitionReassignmentsRequest build(short version) {
            return new AlterPartitionReassignmentsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

