/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public class CopyOnWriteMap<K, V>
implements ConcurrentMap<K, V> {
    private volatile Map<K, V> map;

    public CopyOnWriteMap() {
        this.map = Collections.emptyMap();
    }

    public CopyOnWriteMap(Map<K, V> map) {
        this.map = Collections.unmodifiableMap(map);
    }

    @Override
    public boolean containsKey(Object k) {
        return this.map.containsKey(k);
    }

    @Override
    public boolean containsValue(Object v) {
        return this.map.containsValue(v);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public V get(Object k) {
        return this.map.get(k);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public synchronized void clear() {
        this.map = Collections.emptyMap();
    }

    @Override
    public synchronized V put(K k, V v) {
        HashMap<K, V> copy = new HashMap<K, V>(this.map);
        V prev = copy.put(k, v);
        this.map = Collections.unmodifiableMap(copy);
        return prev;
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> entries) {
        HashMap<? extends K, ? extends V> copy = new HashMap<K, V>(this.map);
        copy.putAll(entries);
        this.map = Collections.unmodifiableMap(copy);
    }

    @Override
    public synchronized V remove(Object key) {
        HashMap<K, V> copy = new HashMap<K, V>(this.map);
        Object prev = copy.remove(key);
        this.map = Collections.unmodifiableMap(copy);
        return prev;
    }

    @Override
    public synchronized V putIfAbsent(K k, V v) {
        if (!this.containsKey(k)) {
            return this.put(k, v);
        }
        return this.get(k);
    }

    @Override
    public synchronized boolean remove(Object k, Object v) {
        if (this.containsKey(k) && this.get(k).equals(v)) {
            this.remove(k);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean replace(K k, V original, V replacement) {
        if (this.containsKey(k) && this.get(k).equals(original)) {
            this.put(k, replacement);
            return true;
        }
        return false;
    }

    @Override
    public synchronized V replace(K k, V v) {
        if (this.containsKey(k)) {
            return this.put(k, v);
        }
        return null;
    }
}

