/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.contrib.streaming.state.RocksDBOptions;
import org.apache.flink.util.Preconditions;

public final class RocksDBMemoryConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Nullable
    private Boolean useManagedMemory;
    @Nullable
    private MemorySize fixedMemoryPerSlot;
    @Nullable
    private Double writeBufferRatio;
    @Nullable
    private Double highPriorityPoolRatio;

    public void setUseManagedMemory(boolean useManagedMemory) {
        this.useManagedMemory = useManagedMemory;
    }

    public void setFixedMemoryPerSlot(MemorySize fixedMemoryPerSlot) {
        Preconditions.checkArgument((fixedMemoryPerSlot == null || fixedMemoryPerSlot.getBytes() > 0L ? 1 : 0) != 0, (Object)"Total memory per slot must be > 0");
        this.fixedMemoryPerSlot = fixedMemoryPerSlot;
    }

    public void setFixedMemoryPerSlot(String totalMemoryPerSlotStr) {
        this.setFixedMemoryPerSlot(MemorySize.parse((String)totalMemoryPerSlotStr));
    }

    public void setWriteBufferRatio(double writeBufferRatio) {
        Preconditions.checkArgument((writeBufferRatio > 0.0 && writeBufferRatio < 1.0 ? 1 : 0) != 0, (String)"Write Buffer ratio %s must be in (0, 1)", (Object[])new Object[]{writeBufferRatio});
        this.writeBufferRatio = writeBufferRatio;
    }

    public void setHighPriorityPoolRatio(double highPriorityPoolRatio) {
        Preconditions.checkArgument((highPriorityPoolRatio > 0.0 && highPriorityPoolRatio < 1.0 ? 1 : 0) != 0, (String)"High priority pool ratio %s must be in (0, 1)", (Object[])new Object[]{highPriorityPoolRatio});
        this.highPriorityPoolRatio = highPriorityPoolRatio;
    }

    public boolean isUsingManagedMemory() {
        return this.useManagedMemory != null ? this.useManagedMemory.booleanValue() : ((Boolean)RocksDBOptions.USE_MANAGED_MEMORY.defaultValue()).booleanValue();
    }

    public boolean isUsingFixedMemoryPerSlot() {
        return this.fixedMemoryPerSlot != null;
    }

    @Nullable
    public MemorySize getFixedMemoryPerSlot() {
        return this.fixedMemoryPerSlot;
    }

    public double getWriteBufferRatio() {
        return this.writeBufferRatio != null ? this.writeBufferRatio.doubleValue() : ((Double)RocksDBOptions.WRITE_BUFFER_RATIO.defaultValue()).doubleValue();
    }

    public double getHighPriorityPoolRatio() {
        return this.highPriorityPoolRatio != null ? this.highPriorityPoolRatio.doubleValue() : ((Double)RocksDBOptions.HIGH_PRIORITY_POOL_RATIO.defaultValue()).doubleValue();
    }

    public void validate() {
        if (this.writeBufferRatio != null && this.highPriorityPoolRatio != null && 2.0 * this.writeBufferRatio / (3.0 - this.writeBufferRatio) + this.highPriorityPoolRatio >= 1.0) {
            throw new IllegalArgumentException(String.format("Invalid configuration: writeBufferRatio %s with highPriPoolRatio %s", this.writeBufferRatio, this.highPriorityPoolRatio));
        }
    }

    public static RocksDBMemoryConfiguration fromOtherAndConfiguration(RocksDBMemoryConfiguration other, Configuration config) {
        RocksDBMemoryConfiguration newConfig = new RocksDBMemoryConfiguration();
        newConfig.useManagedMemory = other.useManagedMemory != null ? other.useManagedMemory.booleanValue() : config.getBoolean(RocksDBOptions.USE_MANAGED_MEMORY);
        newConfig.fixedMemoryPerSlot = other.fixedMemoryPerSlot != null ? other.fixedMemoryPerSlot : (MemorySize)config.get(RocksDBOptions.FIX_PER_SLOT_MEMORY_SIZE);
        newConfig.writeBufferRatio = other.writeBufferRatio != null ? other.writeBufferRatio.doubleValue() : config.getDouble(RocksDBOptions.WRITE_BUFFER_RATIO);
        newConfig.highPriorityPoolRatio = other.highPriorityPoolRatio != null ? other.highPriorityPoolRatio.doubleValue() : config.getDouble(RocksDBOptions.HIGH_PRIORITY_POOL_RATIO);
        return newConfig;
    }
}

