/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state.snapshot;

import java.util.LinkedHashMap;
import java.util.concurrent.RunnableFuture;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.contrib.streaming.state.RocksDBKeyedStateBackend;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.state.AbstractSnapshotStrategy;
import org.apache.flink.runtime.state.CheckpointListener;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.DoneFuture;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.LocalRecoveryConfig;
import org.apache.flink.runtime.state.SnapshotResult;
import org.apache.flink.util.ResourceGuard;
import org.rocksdb.RocksDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RocksDBSnapshotStrategyBase<K>
extends AbstractSnapshotStrategy<KeyedStateHandle>
implements CheckpointListener {
    private static final Logger LOG = LoggerFactory.getLogger(RocksDBSnapshotStrategyBase.class);
    @Nonnull
    protected RocksDB db;
    @Nonnull
    protected final ResourceGuard rocksDBResourceGuard;
    @Nonnull
    protected final TypeSerializer<K> keySerializer;
    @Nonnull
    protected final LinkedHashMap<String, RocksDBKeyedStateBackend.RocksDbKvStateInfo> kvStateInformation;
    @Nonnull
    protected final KeyGroupRange keyGroupRange;
    @Nonnegative
    protected final int keyGroupPrefixBytes;
    @Nonnull
    protected final LocalRecoveryConfig localRecoveryConfig;
    @Nonnull
    protected final CloseableRegistry cancelStreamRegistry;

    public RocksDBSnapshotStrategyBase(@Nonnull String description, @Nonnull RocksDB db, @Nonnull ResourceGuard rocksDBResourceGuard, @Nonnull TypeSerializer<K> keySerializer, @Nonnull LinkedHashMap<String, RocksDBKeyedStateBackend.RocksDbKvStateInfo> kvStateInformation, @Nonnull KeyGroupRange keyGroupRange, @Nonnegative int keyGroupPrefixBytes, @Nonnull LocalRecoveryConfig localRecoveryConfig, @Nonnull CloseableRegistry cancelStreamRegistry) {
        super(description);
        this.db = db;
        this.rocksDBResourceGuard = rocksDBResourceGuard;
        this.keySerializer = keySerializer;
        this.kvStateInformation = kvStateInformation;
        this.keyGroupRange = keyGroupRange;
        this.keyGroupPrefixBytes = keyGroupPrefixBytes;
        this.localRecoveryConfig = localRecoveryConfig;
        this.cancelStreamRegistry = cancelStreamRegistry;
    }

    @Nonnull
    public final RunnableFuture<SnapshotResult<KeyedStateHandle>> snapshot(long checkpointId, long timestamp, @Nonnull CheckpointStreamFactory streamFactory, @Nonnull CheckpointOptions checkpointOptions) throws Exception {
        if (this.kvStateInformation.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Asynchronous RocksDB snapshot performed on empty keyed state at {}. Returning null.", (Object)timestamp);
            }
            return DoneFuture.of((Object)SnapshotResult.empty());
        }
        return this.doSnapshot(checkpointId, timestamp, streamFactory, checkpointOptions);
    }

    @Nonnull
    protected abstract RunnableFuture<SnapshotResult<KeyedStateHandle>> doSnapshot(long var1, long var3, CheckpointStreamFactory var5, CheckpointOptions var6) throws Exception;
}

