/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import org.apache.flink.streaming.api.operators.InputSelection;
import org.junit.Assert;
import org.junit.Test;

public class InputSelectionTest {
    @Test
    public void testIsInputSelected() {
        Assert.assertFalse((boolean)new InputSelection.Builder().build().isInputSelected(1));
        Assert.assertFalse((boolean)new InputSelection.Builder().select(2).build().isInputSelected(1));
        Assert.assertTrue((boolean)new InputSelection.Builder().select(1).build().isInputSelected(1));
        Assert.assertTrue((boolean)new InputSelection.Builder().select(1).select(2).build().isInputSelected(1));
        Assert.assertTrue((boolean)new InputSelection.Builder().select(-1).build().isInputSelected(1));
        Assert.assertTrue((boolean)new InputSelection.Builder().select(64).build().isInputSelected(64));
    }

    @Test
    public void testInputSelectionNormalization() {
        Assert.assertTrue((boolean)InputSelection.ALL.areAllInputsSelected());
        Assert.assertFalse((boolean)new InputSelection.Builder().select(1).select(2).build().areAllInputsSelected());
        Assert.assertTrue((boolean)new InputSelection.Builder().select(1).select(2).build(2).areAllInputsSelected());
        Assert.assertFalse((boolean)new InputSelection.Builder().select(1).select(2).select(3).build().areAllInputsSelected());
        Assert.assertTrue((boolean)new InputSelection.Builder().select(1).select(2).select(3).build(3).areAllInputsSelected());
        Assert.assertFalse((boolean)new InputSelection.Builder().select(1).select(3).build().areAllInputsSelected());
        Assert.assertFalse((boolean)new InputSelection.Builder().select(1).select(3).build(3).areAllInputsSelected());
        Assert.assertFalse((boolean)InputSelection.FIRST.areAllInputsSelected());
        Assert.assertFalse((boolean)InputSelection.SECOND.areAllInputsSelected());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInputSelectionNormalizationOverflow() {
        new InputSelection.Builder().select(3).build(2);
    }

    @Test
    public void testFairSelectNextIndexOutOf2() {
        Assert.assertEquals((long)1L, (long)InputSelection.ALL.fairSelectNextIndexOutOf2(3, 0));
        Assert.assertEquals((long)0L, (long)new InputSelection.Builder().select(1).select(2).build().fairSelectNextIndexOutOf2(3, 1));
        Assert.assertEquals((long)1L, (long)InputSelection.ALL.fairSelectNextIndexOutOf2(2, 0));
        Assert.assertEquals((long)1L, (long)InputSelection.ALL.fairSelectNextIndexOutOf2(2, 1));
        Assert.assertEquals((long)0L, (long)InputSelection.ALL.fairSelectNextIndexOutOf2(1, 0));
        Assert.assertEquals((long)0L, (long)InputSelection.ALL.fairSelectNextIndexOutOf2(1, 1));
        Assert.assertEquals((long)-1L, (long)InputSelection.ALL.fairSelectNextIndexOutOf2(0, 0));
        Assert.assertEquals((long)-1L, (long)InputSelection.ALL.fairSelectNextIndexOutOf2(0, 1));
        Assert.assertEquals((long)0L, (long)InputSelection.FIRST.fairSelectNextIndexOutOf2(1, 0));
        Assert.assertEquals((long)0L, (long)InputSelection.FIRST.fairSelectNextIndexOutOf2(3, 0));
        Assert.assertEquals((long)-1L, (long)InputSelection.FIRST.fairSelectNextIndexOutOf2(2, 0));
        Assert.assertEquals((long)-1L, (long)InputSelection.FIRST.fairSelectNextIndexOutOf2(0, 0));
        Assert.assertEquals((long)1L, (long)InputSelection.SECOND.fairSelectNextIndexOutOf2(2, 1));
        Assert.assertEquals((long)1L, (long)InputSelection.SECOND.fairSelectNextIndexOutOf2(3, 1));
        Assert.assertEquals((long)-1L, (long)InputSelection.SECOND.fairSelectNextIndexOutOf2(1, 1));
        Assert.assertEquals((long)-1L, (long)InputSelection.SECOND.fairSelectNextIndexOutOf2(0, 1));
    }

    @Test
    public void testFairSelectNextIndexWithAllInputsSelected() {
        Assert.assertEquals((long)1L, (long)InputSelection.ALL.fairSelectNextIndex(7L, 0));
        Assert.assertEquals((long)2L, (long)InputSelection.ALL.fairSelectNextIndex(7L, 1));
        Assert.assertEquals((long)0L, (long)InputSelection.ALL.fairSelectNextIndex(7L, 2));
        Assert.assertEquals((long)1L, (long)InputSelection.ALL.fairSelectNextIndex(7L, 0));
        Assert.assertEquals((long)-1L, (long)InputSelection.ALL.fairSelectNextIndex(0L, 2));
        Assert.assertEquals((long)11L, (long)InputSelection.ALL.fairSelectNextIndex(-1L, 10));
        Assert.assertEquals((long)0L, (long)InputSelection.ALL.fairSelectNextIndex(-1L, 63));
        Assert.assertEquals((long)0L, (long)InputSelection.ALL.fairSelectNextIndex(-1L, 158));
    }

    @Test
    public void testFairSelectNextIndexWithSomeInputsSelected() {
        InputSelection selection = new InputSelection.Builder().select(2).select(3).select(4).select(5).select(8).build();
        int availableInputs = (int)new InputSelection.Builder().select(3).select(5).select(6).select(8).build().getInputMask();
        Assert.assertEquals((long)2L, (long)selection.fairSelectNextIndex((long)availableInputs, 0));
        Assert.assertEquals((long)2L, (long)selection.fairSelectNextIndex((long)availableInputs, 1));
        Assert.assertEquals((long)4L, (long)selection.fairSelectNextIndex((long)availableInputs, 2));
        Assert.assertEquals((long)4L, (long)selection.fairSelectNextIndex((long)availableInputs, 3));
        Assert.assertEquals((long)7L, (long)selection.fairSelectNextIndex((long)availableInputs, 4));
        Assert.assertEquals((long)7L, (long)selection.fairSelectNextIndex((long)availableInputs, 5));
        Assert.assertEquals((long)7L, (long)selection.fairSelectNextIndex((long)availableInputs, 6));
        Assert.assertEquals((long)2L, (long)selection.fairSelectNextIndex((long)availableInputs, 7));
        Assert.assertEquals((long)2L, (long)selection.fairSelectNextIndex((long)availableInputs, 8));
        Assert.assertEquals((long)2L, (long)selection.fairSelectNextIndex((long)availableInputs, 158));
        Assert.assertEquals((long)-1L, (long)selection.fairSelectNextIndex(0L, 5));
        Assert.assertEquals((long)-1L, (long)new InputSelection.Builder().build().fairSelectNextIndex(-1L, 5));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testUnsupportedFairSelectNextIndexOutOf2() {
        InputSelection.ALL.fairSelectNextIndexOutOf2(7, 0);
    }

    public static class BuilderTest {
        @Test
        public void testSelect() {
            Assert.assertEquals((long)1L, (long)new InputSelection.Builder().select(1).build().getInputMask());
            Assert.assertEquals((long)7L, (long)new InputSelection.Builder().select(1).select(2).select(3).build().getInputMask());
            Assert.assertEquals((long)Long.MIN_VALUE, (long)new InputSelection.Builder().select(64).build().getInputMask());
            Assert.assertEquals((long)-1L, (long)new InputSelection.Builder().select(-1).build().getInputMask());
        }

        @Test(expected=IllegalArgumentException.class)
        public void testIllegalInputId1() {
            new InputSelection.Builder().select(-2);
        }

        @Test(expected=IllegalArgumentException.class)
        public void testIllegalInputId2() {
            new InputSelection.Builder().select(65);
        }
    }
}

