/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io.benchmark;

import java.io.IOException;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriter;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.io.network.ConnectionID;
import org.apache.flink.runtime.io.network.ConnectionManager;
import org.apache.flink.runtime.io.network.TaskEventPublisher;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferPool;
import org.apache.flink.runtime.io.network.metrics.InputChannelMetrics;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.LocalInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.RemoteInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGateFactory;
import org.apache.flink.runtime.shuffle.NettyShuffleDescriptor;
import org.apache.flink.runtime.taskmanager.NettyShuffleEnvironmentConfiguration;

public class SingleInputGateBenchmarkFactory
extends SingleInputGateFactory {
    public SingleInputGateBenchmarkFactory(ResourceID taskExecutorResourceId, NettyShuffleEnvironmentConfiguration networkConfig, ConnectionManager connectionManager, ResultPartitionManager partitionManager, TaskEventPublisher taskEventPublisher, NetworkBufferPool networkBufferPool) {
        super(taskExecutorResourceId, networkConfig, connectionManager, partitionManager, taskEventPublisher, networkBufferPool);
    }

    protected InputChannel createKnownInputChannel(SingleInputGate inputGate, int index, NettyShuffleDescriptor inputChannelDescriptor, int consumedSubpartitionIndex, SingleInputGateFactory.ChannelStatistics channelStatistics, InputChannelMetrics metrics) {
        ResultPartitionID partitionId = inputChannelDescriptor.getResultPartitionID();
        if (inputChannelDescriptor.isLocalTo(this.taskExecutorResourceId)) {
            return new TestLocalInputChannel(inputGate, index, partitionId, index, this.partitionManager, this.taskEventPublisher, this.partitionRequestInitialBackoff, this.partitionRequestMaxBackoff, metrics);
        }
        return new TestRemoteInputChannel(inputGate, index, partitionId, index, inputChannelDescriptor.getConnectionId(), this.connectionManager, this.partitionRequestInitialBackoff, this.partitionRequestMaxBackoff, this.networkBuffersPerChannel, metrics);
    }

    static class TestRemoteInputChannel
    extends RemoteInputChannel {
        private final ResultPartitionID newPartitionID = new ResultPartitionID();

        public TestRemoteInputChannel(SingleInputGate inputGate, int channelIndex, ResultPartitionID partitionId, int consumedSubpartitionIndex, ConnectionID connectionId, ConnectionManager connectionManager, int initialBackOff, int maxBackoff, int networkBuffersPerChannel, InputChannelMetrics metrics) {
            super(inputGate, channelIndex, partitionId, consumedSubpartitionIndex, connectionId, connectionManager, initialBackOff, maxBackoff, networkBuffersPerChannel, metrics.getNumBytesInRemoteCounter(), metrics.getNumBuffersInRemoteCounter(), ChannelStateWriter.NO_OP);
        }

        public void requestSubpartition() throws IOException, InterruptedException {
            super.requestSubpartition();
        }

        public ResultPartitionID getPartitionId() {
            return this.newPartitionID;
        }
    }

    static class TestLocalInputChannel
    extends LocalInputChannel {
        private final ResultPartitionID newPartitionID = new ResultPartitionID();

        public TestLocalInputChannel(SingleInputGate inputGate, int channelIndex, ResultPartitionID partitionId, int consumedSubpartitionIndex, ResultPartitionManager partitionManager, TaskEventPublisher taskEventPublisher, int initialBackoff, int maxBackoff, InputChannelMetrics metrics) {
            super(inputGate, channelIndex, partitionId, consumedSubpartitionIndex, partitionManager, taskEventPublisher, initialBackoff, maxBackoff, metrics.getNumBytesInLocalCounter(), metrics.getNumBuffersInLocalCounter(), ChannelStateWriter.NO_OP);
        }

        public void requestSubpartition() throws IOException {
            super.requestSubpartition();
        }

        public ResultPartitionID getPartitionId() {
            return this.newPartitionID;
        }
    }
}

