/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.java;

import java.lang.reflect.Constructor;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.table.api.BatchQueryConfig;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.descriptors.BatchTableDescriptor;
import org.apache.flink.table.descriptors.ConnectorDescriptor;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.TableFunction;

@PublicEvolving
public interface BatchTableEnvironment
extends TableEnvironment {
    public <T> void registerFunction(String var1, TableFunction<T> var2);

    public <T, ACC> void registerFunction(String var1, AggregateFunction<T, ACC> var2);

    public <T> Table fromDataSet(DataSet<T> var1);

    public <T> Table fromDataSet(DataSet<T> var1, String var2);

    public <T> void registerDataSet(String var1, DataSet<T> var2);

    public <T> void registerDataSet(String var1, DataSet<T> var2, String var3);

    public <T> DataSet<T> toDataSet(Table var1, Class<T> var2);

    public <T> DataSet<T> toDataSet(Table var1, TypeInformation<T> var2);

    public <T> DataSet<T> toDataSet(Table var1, Class<T> var2, BatchQueryConfig var3);

    public <T> DataSet<T> toDataSet(Table var1, TypeInformation<T> var2, BatchQueryConfig var3);

    public void sqlUpdate(String var1, BatchQueryConfig var2);

    public void insertInto(Table var1, BatchQueryConfig var2, String var3, String ... var4);

    public BatchTableDescriptor connect(ConnectorDescriptor var1);

    public static BatchTableEnvironment create(ExecutionEnvironment executionEnvironment) {
        return BatchTableEnvironment.create(executionEnvironment, new TableConfig());
    }

    public static BatchTableEnvironment create(ExecutionEnvironment executionEnvironment, TableConfig tableConfig) {
        try {
            Class<?> clazz = Class.forName("org.apache.flink.table.api.java.internal.BatchTableEnvironmentImpl");
            Constructor<?> con = clazz.getConstructor(ExecutionEnvironment.class, TableConfig.class, CatalogManager.class);
            String defaultCatalog = "default_catalog";
            CatalogManager catalogManager = new CatalogManager(defaultCatalog, (Catalog)new GenericInMemoryCatalog(defaultCatalog, "default_database"));
            return (BatchTableEnvironment)con.newInstance(executionEnvironment, tableConfig, catalogManager);
        }
        catch (Throwable t) {
            throw new TableException("Create BatchTableEnvironment failed.", t);
        }
    }
}

