/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem.stream;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.streaming.api.functions.sink.filesystem.StreamingFileSink;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.filesystem.stream.AbstractStreamingWriter;
import org.apache.flink.table.filesystem.stream.PartitionCommitInfo;

public class StreamingFileWriter<IN>
extends AbstractStreamingWriter<IN, PartitionCommitInfo> {
    private static final long serialVersionUID = 2L;
    private transient Set<String> inactivePartitions;

    public StreamingFileWriter(long bucketCheckInterval, StreamingFileSink.BucketsBuilder<IN, String, ? extends StreamingFileSink.BucketsBuilder<IN, String, ?>> bucketsBuilder) {
        super(bucketCheckInterval, bucketsBuilder);
    }

    @Override
    public void initializeState(StateInitializationContext context) throws Exception {
        this.inactivePartitions = new HashSet<String>();
        super.initializeState(context);
    }

    @Override
    protected void partitionInactive(String partition) {
        this.inactivePartitions.add(partition);
    }

    @Override
    protected void onPartFileOpened(String s, Path newPath) {
    }

    @Override
    protected void commitUpToCheckpoint(long checkpointId) throws Exception {
        super.commitUpToCheckpoint(checkpointId);
        this.output.collect((Object)new StreamRecord((Object)new PartitionCommitInfo(checkpointId, this.getRuntimeContext().getIndexOfThisSubtask(), this.getRuntimeContext().getNumberOfParallelSubtasks(), new ArrayList<String>(this.inactivePartitions))));
        this.inactivePartitions.clear();
    }
}

