/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem.stream.compact;

import java.io.IOException;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.table.filesystem.stream.compact.CompactContext;
import org.apache.flink.table.filesystem.stream.compact.CompactReader;

public class FileInputFormatCompactReader<T>
implements CompactReader<T> {
    private final FileInputFormat<T> format;

    private FileInputFormatCompactReader(FileInputFormat<T> format) {
        this.format = format;
    }

    @Override
    public T read() throws IOException {
        if (this.format.reachedEnd()) {
            return null;
        }
        return (T)this.format.nextRecord(null);
    }

    @Override
    public void close() throws IOException {
        this.format.close();
    }

    public static <T> CompactReader.Factory<T> factory(FileInputFormat<T> format) {
        return new Factory<T>(format);
    }

    private static class Factory<T>
    implements CompactReader.Factory<T> {
        private final FileInputFormat<T> format;

        public Factory(FileInputFormat<T> format) {
            this.format = format;
        }

        @Override
        public CompactReader<T> create(CompactContext context) throws IOException {
            long len = context.getFileSystem().getFileStatus(context.getPath()).getLen();
            this.format.open(new FileInputSplit(0, context.getPath(), 0L, len, null));
            return new FileInputFormatCompactReader(this.format);
        }
    }
}

