/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.security;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.KerberosTestUtils;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.CollectorInfo;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.client.api.TimelineV2Client;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.api.CollectorNodemanagerProtocol;
import org.apache.hadoop.yarn.server.api.protocolrecords.GetTimelineCollectorContextRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.GetTimelineCollectorContextResponse;
import org.apache.hadoop.yarn.server.timelineservice.collector.AppLevelTimelineCollector;
import org.apache.hadoop.yarn.server.timelineservice.collector.NodeTimelineCollectorManager;
import org.apache.hadoop.yarn.server.timelineservice.collector.PerNodeTimelineCollectorsAuxService;
import org.apache.hadoop.yarn.server.timelineservice.security.TimelineV2DelegationTokenSecretManagerService;
import org.apache.hadoop.yarn.server.timelineservice.storage.FileSystemTimelineReaderImpl;
import org.apache.hadoop.yarn.server.timelineservice.storage.FileSystemTimelineWriterImpl;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineWriter;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
public class TestTimelineAuthFilterForV2 {
    private static final String FOO_USER = "foo";
    private static final String HTTP_USER = "HTTP";
    private static final File TEST_ROOT_DIR = new File(System.getProperty("test.build.dir", "target" + File.separator + "test-dir"), UUID.randomUUID().toString());
    private static final String BASEDIR = System.getProperty("test.build.dir", "target/test-dir") + "/" + TestTimelineAuthFilterForV2.class.getSimpleName();
    private static File httpSpnegoKeytabFile = new File(KerberosTestUtils.getKeytabFile());
    private static String httpSpnegoPrincipal = KerberosTestUtils.getServerPrincipal();
    private static MiniKdc testMiniKDC;
    private static String keystoresDir;
    private static String sslConfDir;
    private static Configuration conf;
    private static UserGroupInformation nonKerberosUser;
    private boolean withSsl;
    private boolean withKerberosLogin;
    private NodeTimelineCollectorManager collectorManager;
    private PerNodeTimelineCollectorsAuxService auxService;

    @Parameterized.Parameters
    public static Collection<Object[]> params() {
        return Arrays.asList({false, true}, {false, false}, {true, false}, {true, true});
    }

    public TestTimelineAuthFilterForV2(boolean withSsl, boolean withKerberosLogin) {
        this.withSsl = withSsl;
        this.withKerberosLogin = withKerberosLogin;
    }

    @BeforeClass
    public static void setup() {
        try {
            testMiniKDC = new MiniKdc(MiniKdc.createConf(), TEST_ROOT_DIR);
            testMiniKDC.start();
            testMiniKDC.createPrincipal(httpSpnegoKeytabFile, new String[]{"HTTP/localhost"});
        }
        catch (Exception e) {
            Assert.fail((String)"Couldn't setup MiniKDC.");
        }
        try {
            conf = new Configuration(false);
            conf.setStrings("yarn.timeline-service.http-authentication.type", new String[]{"kerberos"});
            conf.set("yarn.timeline-service.http-authentication.kerberos.principal", httpSpnegoPrincipal);
            conf.set("yarn.timeline-service.http-authentication.kerberos.keytab", httpSpnegoKeytabFile.getAbsolutePath());
            conf.set("hadoop.security.authentication", "kerberos");
            conf.set("yarn.timeline-service.principal", httpSpnegoPrincipal);
            conf.set("yarn.timeline-service.keytab", httpSpnegoKeytabFile.getAbsolutePath());
            conf.setBoolean("yarn.timeline-service.enabled", true);
            conf.setFloat("yarn.timeline-service.version", 2.0f);
            conf.setClass("yarn.timeline-service.writer.class", FileSystemTimelineWriterImpl.class, TimelineWriter.class);
            conf.set("yarn.timeline-service.bind-host", "localhost");
            conf.set("yarn.timeline-service.fs-writer.root-dir", TEST_ROOT_DIR.getAbsolutePath());
            conf.set("hadoop.proxyuser.HTTP.hosts", "*");
            conf.set("hadoop.proxyuser.HTTP.users", FOO_USER);
            UserGroupInformation.setConfiguration((Configuration)conf);
        }
        catch (Exception e) {
            Assert.fail((String)"Couldn't setup TimelineServer V2.");
        }
    }

    @Before
    public void initialize() throws Exception {
        if (this.withSsl) {
            conf.set("yarn.http.policy", HttpConfig.Policy.HTTPS_ONLY.name());
            File base = new File(BASEDIR);
            FileUtil.fullyDelete((File)base);
            base.mkdirs();
            keystoresDir = new File(BASEDIR).getAbsolutePath();
            sslConfDir = KeyStoreTestUtil.getClasspathDir(TestTimelineAuthFilterForV2.class);
            KeyStoreTestUtil.setupSSLConfig((String)keystoresDir, (String)sslConfDir, (Configuration)conf, (boolean)false);
        } else {
            conf.set("yarn.http.policy", HttpConfig.Policy.HTTP_ONLY.name());
        }
        if (!this.withKerberosLogin) {
            conf.setLong("yarn.timeline-service.delegation.token.renew-interval", 100L);
            conf.setLong("yarn.timeline-service.delegation.token.max-lifetime", 4000L);
        }
        UserGroupInformation.setConfiguration((Configuration)conf);
        this.collectorManager = new DummyNodeTimelineCollectorManager();
        this.auxService = PerNodeTimelineCollectorsAuxService.launchServer((String[])new String[0], (NodeTimelineCollectorManager)this.collectorManager, (Configuration)conf);
        if (this.withKerberosLogin) {
            SecurityUtil.login((Configuration)conf, (String)"yarn.timeline-service.keytab", (String)"yarn.timeline-service.principal", (String)"localhost");
        }
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        this.auxService.addApplication(appId, UserGroupInformation.getCurrentUser().getUserName());
        if (!this.withKerberosLogin) {
            AppLevelTimelineCollector collector = (AppLevelTimelineCollector)this.collectorManager.get(appId);
            Token token = collector.getDelegationTokenForApp();
            token.setService(new Text("localhost" + token.getService().toString().substring(token.getService().toString().indexOf(":"))));
            UserGroupInformation.getCurrentUser().addToken(token);
        }
    }

    private TimelineV2Client createTimelineClientForUGI(ApplicationId appId) {
        TimelineV2Client client = TimelineV2Client.createTimelineClient((ApplicationId)ApplicationId.newInstance((long)0L, (int)1));
        String restBindAddr = this.collectorManager.getRestServerBindAddress();
        String addr = "localhost" + restBindAddr.substring(restBindAddr.indexOf(":"));
        client.setTimelineCollectorInfo(CollectorInfo.newInstance((String)addr));
        client.init(conf);
        client.start();
        return client;
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (testMiniKDC != null) {
            testMiniKDC.stop();
        }
        FileUtil.fullyDelete((File)TEST_ROOT_DIR);
    }

    @After
    public void destroy() throws Exception {
        if (this.auxService != null) {
            this.auxService.stop();
        }
        if (this.withSsl) {
            KeyStoreTestUtil.cleanupSSLConfig((String)keystoresDir, (String)sslConfDir);
            FileUtil.fullyDelete((File)new File(BASEDIR));
        }
        if (this.withKerberosLogin) {
            UserGroupInformation.getCurrentUser().logoutUserFromKeytab();
        }
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)nonKerberosUser.getUserName()));
    }

    private static TimelineEntity createEntity(String id, String type) {
        TimelineEntity entityToStore = new TimelineEntity();
        entityToStore.setId(id);
        entityToStore.setType(type);
        entityToStore.setCreatedTime(Long.valueOf(0L));
        return entityToStore;
    }

    private static void verifyEntity(File entityTypeDir, String id, String type) throws IOException {
        File entityFile = new File(entityTypeDir, id + ".thist");
        Assert.assertTrue((boolean)entityFile.exists());
        TimelineEntity entity = TestTimelineAuthFilterForV2.readEntityFile(entityFile);
        Assert.assertNotNull((Object)entity);
        Assert.assertEquals((Object)id, (Object)entity.getId());
        Assert.assertEquals((Object)type, (Object)entity.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TimelineEntity readEntityFile(File entityFile) throws IOException {
        try (BufferedReader reader = null;){
            String strLine;
            reader = new BufferedReader(new FileReader(entityFile));
            while ((strLine = reader.readLine()) != null) {
                if (strLine.trim().length() <= 0) continue;
                TimelineEntity timelineEntity = (TimelineEntity)FileSystemTimelineReaderImpl.getTimelineRecordFromJSON((String)strLine.trim(), TimelineEntity.class);
                return timelineEntity;
            }
            TimelineEntity timelineEntity = null;
            return timelineEntity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishAndVerifyEntity(ApplicationId appId, File entityTypeDir, String entityType, int numEntities) throws Exception {
        TimelineV2Client client = this.createTimelineClientForUGI(appId);
        try {
            client.putEntities(new TimelineEntity[]{TestTimelineAuthFilterForV2.createEntity("entity1", entityType)});
            Assert.assertEquals((long)numEntities, (long)entityTypeDir.listFiles().length);
            TestTimelineAuthFilterForV2.verifyEntity(entityTypeDir, "entity1", entityType);
            client.putEntitiesAsync(new TimelineEntity[]{TestTimelineAuthFilterForV2.createEntity("entity2", entityType)});
        }
        finally {
            client.stop();
        }
    }

    private boolean publishWithRetries(ApplicationId appId, File entityTypeDir, String entityType, int numEntities) throws Exception {
        for (int i = 0; i < 10; ++i) {
            try {
                this.publishAndVerifyEntity(appId, entityTypeDir, entityType, numEntities);
            }
            catch (YarnException e) {
                Thread.sleep(50L);
                continue;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPutTimelineEntities() throws Exception {
        String entityType = "dummy_type";
        final ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        final File entityTypeDir = new File(TEST_ROOT_DIR.getAbsolutePath() + File.separator + "entities" + File.separator + "yarn_cluster" + File.separator + UserGroupInformation.getCurrentUser().getUserName() + File.separator + "test_flow_name" + File.separator + "test_flow_version" + File.separator + "1" + File.separator + appId.toString() + File.separator + "dummy_type");
        try {
            if (this.withKerberosLogin) {
                KerberosTestUtils.doAs((String)"HTTP/localhost", (Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        TestTimelineAuthFilterForV2.this.publishAndVerifyEntity(appId, entityTypeDir, "dummy_type", 1);
                        return null;
                    }
                });
            } else {
                Assert.assertTrue((String)"Entities should have been published successfully.", (boolean)this.publishWithRetries(appId, entityTypeDir, "dummy_type", 1));
                AppLevelTimelineCollector collector = (AppLevelTimelineCollector)this.collectorManager.get(appId);
                Token token = collector.getDelegationTokenForApp();
                Assert.assertNotNull((Object)token);
                Thread.sleep(1000L);
                Assert.assertTrue((String)"Entities should have been published successfully.", (boolean)this.publishWithRetries(appId, entityTypeDir, "dummy_type", 2));
                Assert.assertNotNull((Object)collector);
                ((TimelineV2DelegationTokenSecretManagerService)Mockito.verify((Object)this.collectorManager.getTokenManagerService(), (VerificationMode)Mockito.atLeastOnce())).renewToken((Token)Matchers.eq((Object)collector.getDelegationTokenForApp()), (String)Matchers.any(String.class));
                Thread.sleep(3000L);
                for (int i = 0; i < 40 && token.equals((Object)collector.getDelegationTokenForApp()); ++i) {
                    Thread.sleep(50L);
                }
                Assert.assertNotEquals((String)"Token should have been regenerated.", (Object)token, (Object)collector.getDelegationTokenForApp());
                Thread.sleep(1000L);
                try {
                    this.publishAndVerifyEntity(appId, entityTypeDir, "dummy_type", 2);
                    Assert.fail((String)"Exception should have been thrown due to Invalid Token.");
                }
                catch (YarnException e) {
                    Assert.assertTrue((String)"Exception thrown should have been due to Invalid Token.", (boolean)e.getCause().getMessage().contains("InvalidToken"));
                }
                Token regeneratedToken = collector.getDelegationTokenForApp();
                regeneratedToken.setService(new Text("localhost" + regeneratedToken.getService().toString().substring(regeneratedToken.getService().toString().indexOf(":"))));
                UserGroupInformation.getCurrentUser().addToken(regeneratedToken);
                Assert.assertTrue((String)"Entities should have been published successfully.", (boolean)this.publishWithRetries(appId, entityTypeDir, "dummy_type", 2));
                ((TimelineV2DelegationTokenSecretManagerService)Mockito.verify((Object)this.collectorManager.getTokenManagerService(), (VerificationMode)Mockito.times((int)2))).generateToken((UserGroupInformation)Matchers.any(UserGroupInformation.class), (String)Matchers.any(String.class));
                Assert.assertEquals((long)1L, (long)((DummyNodeTimelineCollectorManager)this.collectorManager).getTokenExpiredCnt());
            }
            for (int i = 0; i < 50 && entityTypeDir.listFiles().length != 2; ++i) {
                Thread.sleep(50L);
            }
            Assert.assertEquals((long)2L, (long)entityTypeDir.listFiles().length);
            TestTimelineAuthFilterForV2.verifyEntity(entityTypeDir, "entity2", "dummy_type");
            AppLevelTimelineCollector collector = (AppLevelTimelineCollector)this.collectorManager.get(appId);
            Assert.assertNotNull((Object)collector);
            this.auxService.removeApplication(appId);
            ((TimelineV2DelegationTokenSecretManagerService)Mockito.verify((Object)this.collectorManager.getTokenManagerService())).cancelToken((Token)Matchers.eq((Object)collector.getDelegationTokenForApp()), (String)Matchers.any(String.class));
        }
        finally {
            FileUtils.deleteQuietly((File)entityTypeDir);
        }
    }

    static {
        try {
            nonKerberosUser = UserGroupInformation.getCurrentUser();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class DummyNodeTimelineCollectorManager
    extends NodeTimelineCollectorManager {
        private volatile int tokenExpiredCnt = 0;

        DummyNodeTimelineCollectorManager() {
        }

        private int getTokenExpiredCnt() {
            return this.tokenExpiredCnt;
        }

        protected TimelineV2DelegationTokenSecretManagerService createTokenManagerService() {
            return (TimelineV2DelegationTokenSecretManagerService)Mockito.spy((Object)new TimelineV2DelegationTokenSecretManagerService(){

                protected AbstractDelegationTokenSecretManager<TimelineDelegationTokenIdentifier> createTimelineDelegationTokenSecretManager(long secretKeyInterval, long tokenMaxLifetime, long tokenRenewInterval, long tokenRemovalScanInterval) {
                    return (AbstractDelegationTokenSecretManager)Mockito.spy((Object)new TimelineV2DelegationTokenSecretManagerService.TimelineV2DelegationTokenSecretManager(secretKeyInterval, tokenMaxLifetime, tokenRenewInterval, 2000L){

                        protected void logExpireToken(TimelineDelegationTokenIdentifier ident) throws IOException {
                            DummyNodeTimelineCollectorManager.this.tokenExpiredCnt++;
                        }
                    });
                }
            });
        }

        protected CollectorNodemanagerProtocol getNMCollectorService() {
            CollectorNodemanagerProtocol protocol = (CollectorNodemanagerProtocol)Mockito.mock(CollectorNodemanagerProtocol.class);
            try {
                GetTimelineCollectorContextResponse response = GetTimelineCollectorContextResponse.newInstance((String)UserGroupInformation.getCurrentUser().getUserName(), (String)"test_flow_name", (String)"test_flow_version", (long)1L);
                Mockito.when((Object)protocol.getTimelineCollectorContext((GetTimelineCollectorContextRequest)Matchers.any(GetTimelineCollectorContextRequest.class))).thenReturn((Object)response);
            }
            catch (IOException | YarnException e) {
                Assert.fail();
            }
            return protocol;
        }
    }
}

