/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tool;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.time.StopWatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hadoop.hbase.util.RegionSplitter;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public final class Canary
implements Tool {
    private static final int USAGE_EXIT_CODE = 1;
    private static final int INIT_ERROR_EXIT_CODE = 2;
    private static final int TIMEOUT_ERROR_EXIT_CODE = 3;
    private static final int ERROR_EXIT_CODE = 4;
    private static final int FAILURE_EXIT_CODE = 5;
    private static final long DEFAULT_INTERVAL = 60000L;
    private static final long DEFAULT_TIMEOUT = 600000L;
    private static final int MAX_THREADS_NUM = 16;
    private static final Log LOG = LogFactory.getLog(Canary.class);
    public static final TableName DEFAULT_WRITE_TABLE_NAME = TableName.valueOf((String)NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, (String)"canary");
    private static final String CANARY_TABLE_FAMILY_NAME = "Test";
    private Configuration conf = null;
    private long interval = 0L;
    private Sink sink = null;
    private boolean useRegExp;
    private long timeout = 600000L;
    private boolean failOnError = true;
    private boolean regionServerMode = false;
    private boolean regionServerAllRegions = false;
    private boolean writeSniffing = false;
    private boolean treatFailureAsError = false;
    private TableName writeTableName = DEFAULT_WRITE_TABLE_NAME;
    private ExecutorService executor;

    public Canary() {
        this(new ScheduledThreadPoolExecutor(1), new RegionServerStdOutSink());
    }

    public Canary(ExecutorService executor, Sink sink) {
        this.executor = executor;
        this.sink = sink;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    private int parseArgs(String[] args) {
        int index = -1;
        for (int i = 0; i < args.length; ++i) {
            String cmd = args[i];
            if (cmd.startsWith("-")) {
                if (index >= 0) {
                    System.err.println("Invalid command line options");
                    this.printUsageAndExit();
                }
                if (cmd.equals("-help")) {
                    this.printUsageAndExit();
                    continue;
                }
                if (cmd.equals("-daemon") && this.interval == 0L) {
                    this.interval = 60000L;
                    continue;
                }
                if (cmd.equals("-interval")) {
                    if (++i == args.length) {
                        System.err.println("-interval needs a numeric value argument.");
                        this.printUsageAndExit();
                    }
                    try {
                        this.interval = Long.parseLong(args[i]) * 1000L;
                    }
                    catch (NumberFormatException e) {
                        System.err.println("-interval needs a numeric value argument.");
                        this.printUsageAndExit();
                    }
                    continue;
                }
                if (cmd.equals("-regionserver")) {
                    this.regionServerMode = true;
                    continue;
                }
                if (cmd.equals("-allRegions")) {
                    this.regionServerAllRegions = true;
                    continue;
                }
                if (cmd.equals("-writeSniffing")) {
                    this.writeSniffing = true;
                    continue;
                }
                if (cmd.equals("-treatFailureAsError")) {
                    this.treatFailureAsError = true;
                    continue;
                }
                if (cmd.equals("-e")) {
                    this.useRegExp = true;
                    continue;
                }
                if (cmd.equals("-t")) {
                    if (++i == args.length) {
                        System.err.println("-t needs a numeric value argument.");
                        this.printUsageAndExit();
                    }
                    try {
                        this.timeout = Long.parseLong(args[i]);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("-t needs a numeric value argument.");
                        this.printUsageAndExit();
                    }
                    continue;
                }
                if (cmd.equals("-writeTable")) {
                    if (++i == args.length) {
                        System.err.println("-writeTable needs a string value argument.");
                        this.printUsageAndExit();
                    }
                    this.writeTableName = TableName.valueOf((String)args[i]);
                    continue;
                }
                if (cmd.equals("-f")) {
                    if (++i == args.length) {
                        System.err.println("-f needs a boolean value argument (true|false).");
                        this.printUsageAndExit();
                    }
                    this.failOnError = Boolean.parseBoolean(args[i]);
                    continue;
                }
                System.err.println(cmd + " options is invalid.");
                this.printUsageAndExit();
                continue;
            }
            if (index >= 0) continue;
            index = i;
        }
        if (this.regionServerAllRegions && !this.regionServerMode) {
            System.err.println("-allRegions can only be specified in regionserver mode.");
            this.printUsageAndExit();
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int run(String[] args) throws Exception {
        int index = this.parseArgs(args);
        ChoreService choreService = null;
        ScheduledChore authChore = AuthUtil.getAuthChore((Configuration)this.conf);
        if (authChore != null) {
            choreService = new ChoreService("CANARY_TOOL");
            choreService.scheduleChore(authChore);
        }
        Monitor monitor = null;
        Thread monitorThread = null;
        long startTime = 0L;
        long currentTimeLength = 0L;
        try (Connection connection = ConnectionFactory.createConnection((Configuration)this.conf);){
            do {
                try {
                    monitor = this.newMonitor(connection, index, args);
                    monitorThread = new Thread((Runnable)monitor, "CanaryMonitor-" + System.currentTimeMillis());
                    startTime = System.currentTimeMillis();
                    monitorThread.start();
                    while (!monitor.isDone()) {
                        Thread.sleep(1000L);
                        if (this.failOnError && monitor.hasError()) {
                            monitorThread.interrupt();
                            if (monitor.initialized) {
                                int n = monitor.errorCode;
                                return n;
                            }
                            int n = 2;
                            return n;
                        }
                        currentTimeLength = System.currentTimeMillis() - startTime;
                        if (currentTimeLength <= this.timeout) continue;
                        LOG.error((Object)("The monitor is running too long (" + currentTimeLength + ") after timeout limit:" + this.timeout + " will be killed itself !!"));
                        if (monitor.initialized) {
                            int n = 3;
                            return n;
                        }
                        int n = 2;
                        return n;
                    }
                    if (this.failOnError && monitor.finalCheckForErrors()) {
                        monitorThread.interrupt();
                        int n = monitor.errorCode;
                        return n;
                    }
                }
                finally {
                    if (monitor != null) {
                        monitor.close();
                    }
                }
                Thread.sleep(this.interval);
            } while (this.interval > 0L);
        }
        if (choreService == null) return monitor.errorCode;
        choreService.shutdown();
        return monitor.errorCode;
    }

    private void printUsageAndExit() {
        System.err.printf("Usage: bin/hbase %s [opts] [table1 [table2]...] | [regionserver1 [regionserver2]..]%n", this.getClass().getName());
        System.err.println(" where [opts] are:");
        System.err.println("   -help          Show this help and exit.");
        System.err.println("   -regionserver  replace the table argument to regionserver,");
        System.err.println("      which means to enable regionserver mode");
        System.err.println("   -allRegions    Tries all regions on a regionserver,");
        System.err.println("      only works in regionserver mode.");
        System.err.println("   -daemon        Continuous check at defined intervals.");
        System.err.println("   -interval <N>  Interval between checks (sec)");
        System.err.println("   -e             Use region/regionserver as regular expression");
        System.err.println("      which means the region/regionserver is regular expression pattern");
        System.err.println("   -f <B>         stop whole program if first error occurs, default is true");
        System.err.println("   -t <N>         timeout for a check, default is 600000 (milisecs)");
        System.err.println("   -writeSniffing enable the write sniffing in canary");
        System.err.println("   -treatFailureAsError treats read / write failure as error");
        System.err.println("   -writeTable    The table used for write sniffing. Default is hbase:canary");
        System.err.println("   -D<configProperty>=<value> assigning or override the configuration params");
        System.exit(1);
    }

    public Monitor newMonitor(Connection connection, int index, String[] args) {
        Monitor monitor = null;
        String[] monitorTargets = null;
        if (index >= 0) {
            int length = args.length - index;
            monitorTargets = new String[length];
            System.arraycopy(args, index, monitorTargets, 0, length);
        }
        monitor = this.regionServerMode ? new RegionServerMonitor(connection, monitorTargets, this.useRegExp, (ExtendedSink)this.sink, this.executor, this.regionServerAllRegions, this.treatFailureAsError) : new RegionMonitor(connection, monitorTargets, this.useRegExp, this.sink, this.executor, this.writeSniffing, this.writeTableName, this.treatFailureAsError);
        return monitor;
    }

    public static void sniff(Admin admin, TableName tableName) throws Exception {
        Canary.sniff(admin, tableName, RegionTask.TaskType.READ);
    }

    public static void sniff(Admin admin, TableName tableName, RegionTask.TaskType taskType) throws Exception {
        List<Future<Void>> taskFutures = Canary.sniff(admin, (Sink)new StdOutSink(), tableName.getNameAsString(), (ExecutorService)new ScheduledThreadPoolExecutor(1), taskType);
        for (Future<Void> future : taskFutures) {
            future.get();
        }
    }

    private static List<Future<Void>> sniff(Admin admin, Sink sink, String tableName, ExecutorService executor, RegionTask.TaskType taskType) throws Exception {
        if (admin.isTableEnabled(TableName.valueOf((String)tableName))) {
            return Canary.sniff(admin, sink, admin.getTableDescriptor(TableName.valueOf((String)tableName)), executor, taskType);
        }
        LOG.warn((Object)String.format("Table %s is not enabled", tableName));
        return new LinkedList<Future<Void>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Future<Void>> sniff(Admin admin, Sink sink, HTableDescriptor tableDesc, ExecutorService executor, RegionTask.TaskType taskType) throws Exception {
        Table table = null;
        try {
            table = admin.getConnection().getTable(tableDesc.getTableName());
        }
        catch (TableNotFoundException e) {
            return new ArrayList<Future<Void>>();
        }
        ArrayList<RegionTask> tasks = new ArrayList<RegionTask>();
        try {
            for (HRegionInfo region : admin.getTableRegions(tableDesc.getTableName())) {
                tasks.add(new RegionTask(admin.getConnection(), region, sink, taskType));
            }
        }
        finally {
            table.close();
        }
        return executor.invokeAll(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sniffRegion(Admin admin, Sink sink, HRegionInfo region, Table table) throws Exception {
        HTableDescriptor tableDesc = table.getTableDescriptor();
        byte[] startKey = null;
        Get get = null;
        Scan scan = null;
        ResultScanner rs = null;
        StopWatch stopWatch = new StopWatch();
        for (HColumnDescriptor column : tableDesc.getColumnFamilies()) {
            stopWatch.reset();
            startKey = region.getStartKey();
            if (startKey.length > 0) {
                get = new Get(startKey);
                get.setCacheBlocks(false);
                get.setFilter((Filter)new FirstKeyOnlyFilter());
                get.addFamily(column.getName());
            } else {
                scan = new Scan();
                scan.setRaw(true);
                scan.setCaching(1);
                scan.setCacheBlocks(false);
                scan.setFilter((Filter)new FirstKeyOnlyFilter());
                scan.addFamily(column.getName());
                scan.setMaxResultSize(1L);
            }
            try {
                if (startKey.length > 0) {
                    stopWatch.start();
                    table.get(get);
                    stopWatch.stop();
                    sink.publishReadTiming(region, column, stopWatch.getTime());
                    continue;
                }
                stopWatch.start();
                rs = table.getScanner(scan);
                stopWatch.stop();
                sink.publishReadTiming(region, column, stopWatch.getTime());
            }
            catch (Exception e) {
                sink.publishReadFailure(region, column, e);
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                scan = null;
                get = null;
                startKey = null;
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        new GenericOptionsParser(conf, args);
        int numThreads = conf.getInt("hbase.canary.threads.num", 16);
        LOG.info((Object)("Number of exection threads " + numThreads));
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(numThreads);
        Class sinkClass = conf.getClass("hbase.canary.sink.class", RegionServerStdOutSink.class, Sink.class);
        Sink sink = (Sink)ReflectionUtils.newInstance((Class)sinkClass, (Object[])new Object[0]);
        int exitCode = ToolRunner.run((Configuration)conf, (Tool)new Canary(executor, sink), (String[])args);
        executor.shutdown();
        System.exit(exitCode);
    }

    private static class RegionServerMonitor
    extends Monitor {
        private boolean allRegions;

        public RegionServerMonitor(Connection connection, String[] monitorTargets, boolean useRegExp, ExtendedSink sink, ExecutorService executor, boolean allRegions, boolean treatFailureAsError) {
            super(connection, monitorTargets, useRegExp, sink, executor, treatFailureAsError);
            this.allRegions = allRegions;
        }

        private ExtendedSink getSink() {
            return (ExtendedSink)this.sink;
        }

        @Override
        public void run() {
            if (this.initAdmin() && this.checkNoTableNames()) {
                Map<String, List<HRegionInfo>> rsAndRMap = this.filterRegionServerByName();
                this.initialized = true;
                this.monitorRegionServers(rsAndRMap);
            }
            this.done = true;
        }

        private boolean checkNoTableNames() {
            ArrayList<String> foundTableNames = new ArrayList<String>();
            TableName[] tableNames = null;
            try {
                tableNames = this.admin.listTableNames();
            }
            catch (IOException e) {
                LOG.error((Object)"Get listTableNames failed", (Throwable)e);
                this.errorCode = 2;
                return false;
            }
            if (this.targets == null || this.targets.length == 0) {
                return true;
            }
            for (String target : this.targets) {
                for (TableName tableName : tableNames) {
                    if (!target.equals(tableName.getNameAsString())) continue;
                    foundTableNames.add(target);
                }
            }
            if (foundTableNames.size() > 0) {
                System.err.println("Cannot pass a tablename when using the -regionserver option, tablenames:" + ((Object)foundTableNames).toString());
                this.errorCode = 1;
            }
            return foundTableNames.size() == 0;
        }

        private void monitorRegionServers(Map<String, List<HRegionInfo>> rsAndRMap) {
            String serverName;
            ArrayList<RegionServerTask> tasks = new ArrayList<RegionServerTask>();
            HashMap<String, AtomicLong> successMap = new HashMap<String, AtomicLong>();
            Random rand = new Random();
            for (Map.Entry<String, List<HRegionInfo>> entry : rsAndRMap.entrySet()) {
                serverName = entry.getKey();
                AtomicLong successes = new AtomicLong(0L);
                successMap.put(serverName, successes);
                if (entry.getValue().isEmpty()) {
                    LOG.error((Object)String.format("Regionserver not serving any regions - %s", serverName));
                    continue;
                }
                if (this.allRegions) {
                    for (HRegionInfo region : entry.getValue()) {
                        tasks.add(new RegionServerTask(this.connection, serverName, region, this.getSink(), successes));
                    }
                    continue;
                }
                HRegionInfo region = entry.getValue().get(rand.nextInt(entry.getValue().size()));
                tasks.add(new RegionServerTask(this.connection, serverName, region, this.getSink(), successes));
            }
            try {
                for (Future future : this.executor.invokeAll(tasks)) {
                    try {
                        future.get();
                    }
                    catch (ExecutionException e) {
                        LOG.error((Object)"Sniff regionserver failed!", (Throwable)e);
                        this.errorCode = 4;
                    }
                }
                if (this.allRegions) {
                    for (Map.Entry entry : rsAndRMap.entrySet()) {
                        serverName = (String)entry.getKey();
                        LOG.info((Object)("Successfully read " + successMap.get(serverName) + " regions out of " + ((List)entry.getValue()).size() + " on regionserver:" + serverName));
                    }
                }
            }
            catch (InterruptedException e) {
                this.errorCode = 4;
                LOG.error((Object)"Sniff regionserver interrupted!", (Throwable)e);
            }
        }

        private Map<String, List<HRegionInfo>> filterRegionServerByName() {
            Map<String, List<HRegionInfo>> regionServerAndRegionsMap = this.getAllRegionServerByName();
            regionServerAndRegionsMap = this.doFilterRegionServerByName(regionServerAndRegionsMap);
            return regionServerAndRegionsMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, List<HRegionInfo>> getAllRegionServerByName() {
            HashMap<String, List<HRegionInfo>> rsAndRMap = new HashMap<String, List<HRegionInfo>>();
            Table table = null;
            RegionLocator regionLocator = null;
            try {
                HTableDescriptor[] tableDescs = this.admin.listTables();
                List<HRegionInfo> regions = null;
                for (HTableDescriptor tableDesc : tableDescs) {
                    table = this.admin.getConnection().getTable(tableDesc.getTableName());
                    regionLocator = this.admin.getConnection().getRegionLocator(tableDesc.getTableName());
                    for (HRegionLocation location : regionLocator.getAllRegionLocations()) {
                        ServerName rs = location.getServerName();
                        String rsName = rs.getHostname();
                        HRegionInfo r = location.getRegionInfo();
                        if (rsAndRMap.containsKey(rsName)) {
                            regions = (List)rsAndRMap.get(rsName);
                        } else {
                            regions = new ArrayList();
                            rsAndRMap.put(rsName, regions);
                        }
                        regions.add(r);
                    }
                    table.close();
                }
                for (ServerName rs : this.admin.getClusterStatus().getServers()) {
                    String rsName = rs.getHostname();
                    if (rsAndRMap.containsKey(rsName)) continue;
                    rsAndRMap.put(rsName, Collections.emptyList());
                }
            }
            catch (IOException e) {
                String msg = "Get HTables info failed";
                LOG.error((Object)msg, (Throwable)e);
                this.errorCode = 2;
            }
            finally {
                if (table != null) {
                    try {
                        table.close();
                    }
                    catch (IOException e) {
                        LOG.warn((Object)"Close table failed", (Throwable)e);
                    }
                }
            }
            return rsAndRMap;
        }

        private Map<String, List<HRegionInfo>> doFilterRegionServerByName(Map<String, List<HRegionInfo>> fullRsAndRMap) {
            Map<String, List<HRegionInfo>> filteredRsAndRMap = null;
            if (this.targets != null && this.targets.length > 0) {
                filteredRsAndRMap = new HashMap<String, List<HRegionInfo>>();
                Pattern pattern = null;
                Matcher matcher = null;
                boolean regExpFound = false;
                for (String rsName : this.targets) {
                    if (this.useRegExp) {
                        regExpFound = false;
                        pattern = Pattern.compile(rsName);
                        for (Map.Entry<String, List<HRegionInfo>> entry : fullRsAndRMap.entrySet()) {
                            matcher = pattern.matcher(entry.getKey());
                            if (!matcher.matches()) continue;
                            filteredRsAndRMap.put(entry.getKey(), entry.getValue());
                            regExpFound = true;
                        }
                        if (regExpFound) continue;
                        LOG.info((Object)("No RegionServerInfo found, regionServerPattern:" + rsName));
                        continue;
                    }
                    if (fullRsAndRMap.containsKey(rsName)) {
                        filteredRsAndRMap.put(rsName, fullRsAndRMap.get(rsName));
                        continue;
                    }
                    LOG.info((Object)("No RegionServerInfo found, regionServerName:" + rsName));
                }
            } else {
                filteredRsAndRMap = fullRsAndRMap;
            }
            return filteredRsAndRMap;
        }
    }

    private static class RegionMonitor
    extends Monitor {
        private static final int DEFAULT_WRITE_TABLE_CHECK_PERIOD = 600000;
        private static final int DEFAULT_WRITE_DATA_TTL = 86400;
        private long lastCheckTime = -1L;
        private boolean writeSniffing;
        private TableName writeTableName;
        private int writeDataTTL;
        private float regionsLowerLimit;
        private float regionsUpperLimit;
        private int checkPeriod;

        public RegionMonitor(Connection connection, String[] monitorTargets, boolean useRegExp, Sink sink, ExecutorService executor, boolean writeSniffing, TableName writeTableName, boolean treatFailureAsError) {
            super(connection, monitorTargets, useRegExp, sink, executor, treatFailureAsError);
            Configuration conf = connection.getConfiguration();
            this.writeSniffing = writeSniffing;
            this.writeTableName = writeTableName;
            this.writeDataTTL = conf.getInt("hbase.canary.write.data.ttl", 86400);
            this.regionsLowerLimit = conf.getFloat("hbase.canary.write.perserver.regions.lowerLimit", 1.0f);
            this.regionsUpperLimit = conf.getFloat("hbase.canary.write.perserver.regions.upperLimit", 1.5f);
            this.checkPeriod = conf.getInt("hbase.canary.write.table.check.period", 600000);
        }

        @Override
        public void run() {
            if (this.initAdmin()) {
                try {
                    LinkedList<Future<Void>> taskFutures = new LinkedList<Future<Void>>();
                    if (this.targets != null && this.targets.length > 0) {
                        String[] tables = this.generateMonitorTables(this.targets);
                        this.initialized = true;
                        for (String table : tables) {
                            taskFutures.addAll(Canary.sniff(this.admin, this.sink, table, this.executor, RegionTask.TaskType.READ));
                        }
                    } else {
                        taskFutures.addAll(this.sniff(RegionTask.TaskType.READ));
                    }
                    if (this.writeSniffing) {
                        if (EnvironmentEdgeManager.currentTime() - this.lastCheckTime > (long)this.checkPeriod) {
                            try {
                                this.checkWriteTableDistribution();
                            }
                            catch (IOException e) {
                                LOG.error((Object)"Check canary table distribution failed!", (Throwable)e);
                            }
                            this.lastCheckTime = EnvironmentEdgeManager.currentTime();
                        }
                        taskFutures.addAll(Canary.sniff(this.admin, this.sink, this.admin.getTableDescriptor(this.writeTableName), this.executor, RegionTask.TaskType.WRITE));
                    }
                    for (Future future : taskFutures) {
                        try {
                            future.get();
                        }
                        catch (ExecutionException e) {
                            LOG.error((Object)"Sniff region failed!", (Throwable)e);
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Run regionMonitor failed", (Throwable)e);
                    this.errorCode = 4;
                }
            }
            this.done = true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String[] generateMonitorTables(String[] monitorTargets) throws IOException {
            String[] returnTables = null;
            if (!this.useRegExp) return monitorTargets;
            Pattern pattern = null;
            HTableDescriptor[] tds = null;
            TreeSet<String> tmpTables = new TreeSet<String>();
            try {
                for (String monitorTarget : monitorTargets) {
                    pattern = Pattern.compile(monitorTarget);
                    tds = this.admin.listTables(pattern);
                    if (tds == null) continue;
                    for (HTableDescriptor td : tds) {
                        tmpTables.add(td.getNameAsString());
                    }
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Communicate with admin failed", (Throwable)e);
                throw e;
            }
            if (tmpTables.size() > 0) {
                return tmpTables.toArray(new String[tmpTables.size()]);
            }
            String msg = "No HTable found, tablePattern:" + Arrays.toString(monitorTargets);
            LOG.error((Object)msg);
            this.errorCode = 2;
            throw new TableNotFoundException(msg);
        }

        private List<Future<Void>> sniff(RegionTask.TaskType taskType) throws Exception {
            LinkedList<Future<Void>> taskFutures = new LinkedList<Future<Void>>();
            for (HTableDescriptor table : this.admin.listTables()) {
                if (!this.admin.isTableEnabled(table.getTableName()) || table.getTableName().equals((Object)this.writeTableName)) continue;
                taskFutures.addAll(Canary.sniff(this.admin, this.sink, table, this.executor, taskType));
            }
            return taskFutures;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkWriteTableDistribution() throws IOException {
            List locations;
            int numberOfServers;
            if (!this.admin.tableExists(this.writeTableName)) {
                numberOfServers = this.admin.getClusterStatus().getServers().size();
                if (numberOfServers == 0) {
                    throw new IllegalStateException("No live regionservers");
                }
                this.createWriteTable(numberOfServers);
            }
            if (!this.admin.isTableEnabled(this.writeTableName)) {
                this.admin.enableTable(this.writeTableName);
            }
            numberOfServers = this.admin.getClusterStatus().getServers().size();
            try (RegionLocator locator = this.connection.getRegionLocator(this.writeTableName);){
                locations = locator.getAllRegionLocations();
            }
            int numberOfRegions = locations.size();
            if ((float)numberOfRegions < (float)numberOfServers * this.regionsLowerLimit || (float)numberOfRegions > (float)numberOfServers * this.regionsUpperLimit) {
                this.admin.disableTable(this.writeTableName);
                this.admin.deleteTable(this.writeTableName);
                this.createWriteTable(numberOfServers);
            }
            HashSet<ServerName> serverSet = new HashSet<ServerName>();
            for (HRegionLocation location : locations) {
                serverSet.add(location.getServerName());
            }
            int numberOfCoveredServers = serverSet.size();
            if (numberOfCoveredServers < numberOfServers) {
                this.admin.balancer();
            }
        }

        private void createWriteTable(int numberOfServers) throws IOException {
            int numberOfRegions = (int)((float)numberOfServers * this.regionsLowerLimit);
            LOG.info((Object)("Number of live regionservers: " + numberOfServers + ", " + "pre-splitting the canary table into " + numberOfRegions + " regions " + "(current  lower limi of regions per server is " + this.regionsLowerLimit + " and you can change it by config: " + "hbase.canary.write.perserver.regions.lowerLimit" + " )"));
            HTableDescriptor desc = new HTableDescriptor(this.writeTableName);
            HColumnDescriptor family = new HColumnDescriptor(Canary.CANARY_TABLE_FAMILY_NAME);
            family.setMaxVersions(1);
            family.setTimeToLive(this.writeDataTTL);
            desc.addFamily(family);
            byte[][] splits = new RegionSplitter.HexStringSplit().split(numberOfRegions);
            this.admin.createTable(desc, splits);
        }
    }

    public static abstract class Monitor
    implements Runnable,
    Closeable {
        protected Connection connection;
        protected Admin admin;
        protected String[] targets;
        protected boolean useRegExp;
        protected boolean treatFailureAsError;
        protected boolean initialized = false;
        protected boolean done = false;
        protected int errorCode = 0;
        protected Sink sink;
        protected ExecutorService executor;

        public boolean isDone() {
            return this.done;
        }

        public boolean hasError() {
            return this.errorCode != 0;
        }

        public boolean finalCheckForErrors() {
            if (this.errorCode != 0) {
                return true;
            }
            if (this.treatFailureAsError && (this.sink.getReadFailureCount() > 0L || this.sink.getWriteFailureCount() > 0L)) {
                this.errorCode = 5;
                return true;
            }
            return false;
        }

        @Override
        public void close() throws IOException {
            if (this.admin != null) {
                this.admin.close();
            }
        }

        protected Monitor(Connection connection, String[] monitorTargets, boolean useRegExp, Sink sink, ExecutorService executor, boolean treatFailureAsError) {
            if (null == connection) {
                throw new IllegalArgumentException("connection shall not be null");
            }
            this.connection = connection;
            this.targets = monitorTargets;
            this.useRegExp = useRegExp;
            this.treatFailureAsError = treatFailureAsError;
            this.sink = sink;
            this.executor = executor;
        }

        @Override
        public abstract void run();

        protected boolean initAdmin() {
            if (null == this.admin) {
                try {
                    this.admin = this.connection.getAdmin();
                }
                catch (Exception e) {
                    LOG.error((Object)"Initial HBaseAdmin failed...", (Throwable)e);
                    this.errorCode = 2;
                }
            } else if (this.admin.isAborted()) {
                LOG.error((Object)"HBaseAdmin aborted");
                this.errorCode = 2;
            }
            return !this.hasError();
        }
    }

    static class RegionServerTask
    implements Callable<Void> {
        private Connection connection;
        private String serverName;
        private HRegionInfo region;
        private ExtendedSink sink;
        private AtomicLong successes;

        RegionServerTask(Connection connection, String serverName, HRegionInfo region, ExtendedSink sink, AtomicLong successes) {
            this.connection = connection;
            this.serverName = serverName;
            this.region = region;
            this.sink = sink;
            this.successes = successes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() {
            TableName tableName = null;
            Table table = null;
            Get get = null;
            byte[] startKey = null;
            Scan scan = null;
            StopWatch stopWatch = new StopWatch();
            stopWatch.reset();
            try {
                tableName = this.region.getTable();
                table = this.connection.getTable(tableName);
                startKey = this.region.getStartKey();
                if (startKey.length > 0) {
                    get = new Get(startKey);
                    get.setCacheBlocks(false);
                    get.setFilter((Filter)new FirstKeyOnlyFilter());
                    stopWatch.start();
                    table.get(get);
                    stopWatch.stop();
                } else {
                    scan = new Scan();
                    scan.setCacheBlocks(false);
                    scan.setFilter((Filter)new FirstKeyOnlyFilter());
                    scan.setCaching(1);
                    scan.setMaxResultSize(1L);
                    stopWatch.start();
                    ResultScanner s = table.getScanner(scan);
                    s.close();
                    stopWatch.stop();
                }
                this.successes.incrementAndGet();
                this.sink.publishReadTiming(tableName.getNameAsString(), this.serverName, stopWatch.getTime());
            }
            catch (TableNotFoundException tnfe) {
                LOG.error((Object)"Table may be deleted", (Throwable)tnfe);
            }
            catch (TableNotEnabledException tnee) {
                this.successes.incrementAndGet();
                LOG.debug((Object)"The targeted table was disabled.  Assuming success.");
            }
            catch (DoNotRetryIOException dnrioe) {
                this.sink.publishReadFailure(tableName.getNameAsString(), this.serverName);
                LOG.error((Object)dnrioe);
            }
            catch (IOException e) {
                this.sink.publishReadFailure(tableName.getNameAsString(), this.serverName);
                LOG.error((Object)e);
            }
            finally {
                if (table != null) {
                    try {
                        table.close();
                    }
                    catch (IOException e) {
                        LOG.error((Object)"Close table failed", (Throwable)e);
                    }
                }
                scan = null;
                get = null;
                startKey = null;
            }
            return null;
        }
    }

    static class RegionTask
    implements Callable<Void> {
        private Connection connection;
        private HRegionInfo region;
        private Sink sink;
        private TaskType taskType;

        RegionTask(Connection connection, HRegionInfo region, Sink sink, TaskType taskType) {
            this.connection = connection;
            this.region = region;
            this.sink = sink;
            this.taskType = taskType;
        }

        @Override
        public Void call() {
            switch (this.taskType) {
                case READ: {
                    return this.read();
                }
                case WRITE: {
                    return this.write();
                }
            }
            return this.read();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void read() {
            Table table = null;
            HTableDescriptor tableDesc = null;
            try {
                table = this.connection.getTable(this.region.getTable());
                tableDesc = table.getTableDescriptor();
            }
            catch (IOException e) {
                LOG.debug((Object)"sniffRegion failed", (Throwable)e);
                this.sink.publishReadFailure(this.region, e);
                if (table != null) {
                    try {
                        table.close();
                    }
                    catch (IOException ioe) {
                        LOG.error((Object)"Close table failed", (Throwable)e);
                    }
                }
                return null;
            }
            byte[] startKey = null;
            Get get = null;
            Scan scan = null;
            ResultScanner rs = null;
            StopWatch stopWatch = new StopWatch();
            for (HColumnDescriptor column : tableDesc.getColumnFamilies()) {
                stopWatch.reset();
                startKey = this.region.getStartKey();
                if (startKey.length > 0) {
                    get = new Get(startKey);
                    get.setCacheBlocks(false);
                    get.setFilter((Filter)new FirstKeyOnlyFilter());
                    get.addFamily(column.getName());
                } else {
                    scan = new Scan();
                    scan.setCaching(1);
                    scan.setCacheBlocks(false);
                    scan.setFilter((Filter)new FirstKeyOnlyFilter());
                    scan.addFamily(column.getName());
                    scan.setMaxResultSize(1L);
                }
                try {
                    if (startKey.length > 0) {
                        stopWatch.start();
                        table.get(get);
                        stopWatch.stop();
                        this.sink.publishReadTiming(this.region, column, stopWatch.getTime());
                        continue;
                    }
                    stopWatch.start();
                    rs = table.getScanner(scan);
                    stopWatch.stop();
                    this.sink.publishReadTiming(this.region, column, stopWatch.getTime());
                }
                catch (Exception e) {
                    this.sink.publishReadFailure(this.region, column, e);
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                    scan = null;
                    get = null;
                    startKey = null;
                }
            }
            try {
                table.close();
            }
            catch (IOException e) {
                LOG.error((Object)"Close table failed", (Throwable)e);
            }
            return null;
        }

        private Void write() {
            Table table = null;
            HTableDescriptor tableDesc = null;
            try {
                table = this.connection.getTable(this.region.getTable());
                tableDesc = table.getTableDescriptor();
                byte[] rowToCheck = this.region.getStartKey();
                if (rowToCheck.length == 0) {
                    rowToCheck = new byte[]{0};
                }
                int writeValueSize = this.connection.getConfiguration().getInt("hbase.canary.write.value.size", 10);
                for (HColumnDescriptor column : tableDesc.getColumnFamilies()) {
                    Put put = new Put(rowToCheck);
                    byte[] value = new byte[writeValueSize];
                    Bytes.random((byte[])value);
                    put.addColumn(column.getName(), HConstants.EMPTY_BYTE_ARRAY, value);
                    try {
                        long startTime = System.currentTimeMillis();
                        table.put(put);
                        long time = System.currentTimeMillis() - startTime;
                        this.sink.publishWriteTiming(this.region, column, time);
                    }
                    catch (Exception e) {
                        this.sink.publishWriteFailure(this.region, column, e);
                    }
                }
                table.close();
            }
            catch (IOException e) {
                this.sink.publishWriteFailure(this.region, e);
            }
            return null;
        }

        public static enum TaskType {
            READ,
            WRITE;

        }
    }

    public static class RegionServerStdOutSink
    extends StdOutSink
    implements ExtendedSink {
        @Override
        public void publishReadFailure(String table, String server) {
            this.incReadFailureCount();
            LOG.error((Object)String.format("Read from table:%s on region server:%s", table, server));
        }

        @Override
        public void publishReadTiming(String table, String server, long msTime) {
            LOG.info((Object)String.format("Read from table:%s on region server:%s in %dms", table, server, msTime));
        }
    }

    public static class StdOutSink
    implements Sink {
        private AtomicLong readFailureCount = new AtomicLong(0L);
        private AtomicLong writeFailureCount = new AtomicLong(0L);

        @Override
        public long getReadFailureCount() {
            return this.readFailureCount.get();
        }

        @Override
        public long incReadFailureCount() {
            return this.readFailureCount.incrementAndGet();
        }

        @Override
        public void publishReadFailure(HRegionInfo region, Exception e) {
            this.readFailureCount.incrementAndGet();
            LOG.error((Object)String.format("read from region %s failed", region.getRegionNameAsString()), (Throwable)e);
        }

        @Override
        public void publishReadFailure(HRegionInfo region, HColumnDescriptor column, Exception e) {
            this.readFailureCount.incrementAndGet();
            LOG.error((Object)String.format("read from region %s column family %s failed", region.getRegionNameAsString(), column.getNameAsString()), (Throwable)e);
        }

        @Override
        public void publishReadTiming(HRegionInfo region, HColumnDescriptor column, long msTime) {
            LOG.info((Object)String.format("read from region %s column family %s in %dms", region.getRegionNameAsString(), column.getNameAsString(), msTime));
        }

        @Override
        public long getWriteFailureCount() {
            return this.writeFailureCount.get();
        }

        @Override
        public void publishWriteFailure(HRegionInfo region, Exception e) {
            this.writeFailureCount.incrementAndGet();
            LOG.error((Object)String.format("write to region %s failed", region.getRegionNameAsString()), (Throwable)e);
        }

        @Override
        public void publishWriteFailure(HRegionInfo region, HColumnDescriptor column, Exception e) {
            this.writeFailureCount.incrementAndGet();
            LOG.error((Object)String.format("write to region %s column family %s failed", region.getRegionNameAsString(), column.getNameAsString()), (Throwable)e);
        }

        @Override
        public void publishWriteTiming(HRegionInfo region, HColumnDescriptor column, long msTime) {
            LOG.info((Object)String.format("write to region %s column family %s in %dms", region.getRegionNameAsString(), column.getNameAsString(), msTime));
        }
    }

    public static interface ExtendedSink
    extends Sink {
        public void publishReadFailure(String var1, String var2);

        public void publishReadTiming(String var1, String var2, long var3);
    }

    public static interface Sink {
        public long getReadFailureCount();

        public long incReadFailureCount();

        public void publishReadFailure(HRegionInfo var1, Exception var2);

        public void publishReadFailure(HRegionInfo var1, HColumnDescriptor var2, Exception var3);

        public void publishReadTiming(HRegionInfo var1, HColumnDescriptor var2, long var3);

        public long getWriteFailureCount();

        public void publishWriteFailure(HRegionInfo var1, Exception var2);

        public void publishWriteFailure(HRegionInfo var1, HColumnDescriptor var2, Exception var3);

        public void publishWriteTiming(HRegionInfo var1, HColumnDescriptor var2, long var3);
    }
}

