/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.shims;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.ProxyFileSystem;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.HadoopShimsSecure;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.hive.shims.ZeroCopyShims;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.JobContextImpl;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.WebHCatJTShim23;
import org.apache.hadoop.mapred.lib.TotalOrderPartitioner;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.mapreduce.util.HostUtil;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Progressable;
import org.apache.tez.test.MiniTezCluster;

public class Hadoop23Shims
extends HadoopShimsSecure {
    HadoopShims.MiniDFSShim cluster = null;
    final boolean zeroCopy;
    private volatile HadoopShims.HCatHadoopShims hcatShimInstance;

    public Hadoop23Shims() {
        boolean zcr = false;
        try {
            Class.forName("org.apache.hadoop.fs.CacheFlag", false, ShimLoader.class.getClassLoader());
            zcr = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.zeroCopy = zcr;
    }

    public String getTaskAttemptLogUrl(JobConf conf, String taskTrackerHttpAddress, String taskAttemptId) throws MalformedURLException {
        if (conf.get("mapreduce.framework.name") != null && conf.get("mapreduce.framework.name").equals("yarn")) {
            LOG.warn((Object)"Can't fetch tasklog: TaskLogServlet is not supported in MR2 mode.");
            return null;
        }
        URL taskTrackerHttpURL = new URL(taskTrackerHttpAddress);
        return HostUtil.getTaskLogUrl((String)taskTrackerHttpURL.getHost(), (String)Integer.toString(taskTrackerHttpURL.getPort()), (String)taskAttemptId);
    }

    public HadoopShims.JobTrackerState getJobTrackerState(ClusterStatus clusterStatus) throws Exception {
        switch (clusterStatus.getJobTrackerStatus()) {
            case INITIALIZING: {
                return HadoopShims.JobTrackerState.INITIALIZING;
            }
            case RUNNING: {
                return HadoopShims.JobTrackerState.RUNNING;
            }
        }
        String errorMsg = "Unrecognized JobTracker state: " + clusterStatus.getJobTrackerStatus();
        throw new Exception(errorMsg);
    }

    public TaskAttemptContext newTaskAttemptContext(Configuration conf, final Progressable progressable) {
        org.apache.hadoop.mapreduce.TaskAttemptID taskAttemptId = org.apache.hadoop.mapreduce.TaskAttemptID.forName((String)conf.get("mapreduce.task.attempt.id"));
        if (taskAttemptId == null) {
            taskAttemptId = new org.apache.hadoop.mapreduce.TaskAttemptID();
        }
        return new TaskAttemptContextImpl(conf, taskAttemptId){

            public void progress() {
                progressable.progress();
            }
        };
    }

    public org.apache.hadoop.mapreduce.TaskAttemptID newTaskAttemptID(JobID jobId, boolean isMap, int taskId, int id) {
        return new org.apache.hadoop.mapreduce.TaskAttemptID(jobId.getJtIdentifier(), jobId.getId(), isMap ? TaskType.MAP : TaskType.REDUCE, taskId, id);
    }

    public org.apache.hadoop.mapreduce.JobContext newJobContext(Job job) {
        return new org.apache.hadoop.mapreduce.task.JobContextImpl(job.getConfiguration(), job.getJobID());
    }

    public boolean isLocalMode(Configuration conf) {
        return "local".equals(conf.get("mapreduce.framework.name"));
    }

    public String getJobLauncherRpcAddress(Configuration conf) {
        return conf.get("yarn.resourcemanager.address");
    }

    public void setJobLauncherRpcAddress(Configuration conf, String val) {
        if (val.equals("local")) {
            conf.set("mapreduce.framework.name", val);
            conf.set("mapreduce.jobtracker.address", val);
        } else {
            conf.set("mapreduce.framework.name", "yarn");
            conf.set("yarn.resourcemanager.address", val);
        }
    }

    public String getJobLauncherHttpAddress(Configuration conf) {
        return conf.get("yarn.resourcemanager.webapp.address");
    }

    public long getDefaultBlockSize(FileSystem fs, Path path) {
        return fs.getDefaultBlockSize(path);
    }

    public short getDefaultReplication(FileSystem fs, Path path) {
        return fs.getDefaultReplication(path);
    }

    public boolean moveToAppropriateTrash(FileSystem fs, Path path, Configuration conf) throws IOException {
        return Trash.moveToAppropriateTrash((FileSystem)fs, (Path)path, (Configuration)conf);
    }

    public void setTotalOrderPartitionFile(JobConf jobConf, Path partitionFile) {
        TotalOrderPartitioner.setPartitionFile((JobConf)jobConf, (Path)partitionFile);
    }

    public Comparator<LongWritable> getLongComparator() {
        return new Comparator<LongWritable>(){

            @Override
            public int compare(LongWritable o1, LongWritable o2) {
                return o1.compareTo(o2);
            }
        };
    }

    public MiniMrShim getMiniMrCluster(Configuration conf, int numberOfTaskTrackers, String nameNode, int numDir) throws IOException {
        return new MiniMrShim(conf, numberOfTaskTrackers, nameNode, numDir);
    }

    public MiniMrShim getMiniTezCluster(Configuration conf, int numberOfTaskTrackers, String nameNode, int numDir) throws IOException {
        return new MiniTezShim(conf, numberOfTaskTrackers, nameNode, numDir);
    }

    public HadoopShims.MiniDFSShim getMiniDfs(Configuration conf, int numDataNodes, boolean format, String[] racks) throws IOException {
        this.cluster = new MiniDFSShim(new MiniDFSCluster(conf, numDataNodes, format, racks));
        return this.cluster;
    }

    public HadoopShims.HCatHadoopShims getHCatShim() {
        if (this.hcatShimInstance == null) {
            this.hcatShimInstance = new HCatHadoopShims23();
        }
        return this.hcatShimInstance;
    }

    public HadoopShims.WebHCatJTShim getWebHCatShim(Configuration conf, UserGroupInformation ugi) throws IOException {
        return new WebHCatJTShim23(conf, ugi);
    }

    public List<FileStatus> listLocatedStatus(FileSystem fs, Path path, PathFilter filter) throws IOException {
        RemoteIterator itr = fs.listLocatedStatus(path);
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        while (itr.hasNext()) {
            FileStatus stat = (FileStatus)itr.next();
            if (filter != null && !filter.accept(stat.getPath())) continue;
            result.add(stat);
        }
        return result;
    }

    public BlockLocation[] getLocations(FileSystem fs, FileStatus status) throws IOException {
        if (status instanceof LocatedFileStatus) {
            return ((LocatedFileStatus)status).getBlockLocations();
        }
        return fs.getFileBlockLocations(status, 0L, status.getLen());
    }

    public void hflush(FSDataOutputStream stream) throws IOException {
        stream.hflush();
    }

    public FileSystem createProxyFileSystem(FileSystem fs, URI uri) {
        return new ProxyFileSystem23(fs, uri);
    }

    public Map<String, String> getHadoopConfNames() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("HADOOPFS", "fs.defaultFS");
        ret.put("HADOOPMAPFILENAME", "mapreduce.map.input.file");
        ret.put("HADOOPMAPREDINPUTDIR", "mapreduce.input.fileinputformat.inputdir");
        ret.put("HADOOPMAPREDINPUTDIRRECURSIVE", "mapreduce.input.fileinputformat.input.dir.recursive");
        ret.put("MAPREDMAXSPLITSIZE", "mapreduce.input.fileinputformat.split.maxsize");
        ret.put("MAPREDMINSPLITSIZE", "mapreduce.input.fileinputformat.split.minsize");
        ret.put("MAPREDMINSPLITSIZEPERNODE", "mapreduce.input.fileinputformat.split.minsize.per.node");
        ret.put("MAPREDMINSPLITSIZEPERRACK", "mapreduce.input.fileinputformat.split.minsize.per.rack");
        ret.put("HADOOPNUMREDUCERS", "mapreduce.job.reduces");
        ret.put("HADOOPJOBNAME", "mapreduce.job.name");
        ret.put("HADOOPSPECULATIVEEXECREDUCERS", "mapreduce.reduce.speculative");
        ret.put("MAPREDSETUPCLEANUPNEEDED", "mapreduce.job.committer.setup.cleanup.needed");
        ret.put("MAPREDTASKCLEANUPNEEDED", "mapreduce.job.committer.task.cleanup.needed");
        return ret;
    }

    public HadoopShims.ZeroCopyReaderShim getZeroCopyReader(FSDataInputStream in, HadoopShims.ByteBufferPoolShim pool) throws IOException {
        if (this.zeroCopy) {
            return ZeroCopyShims.getZeroCopyReader(in, pool);
        }
        return null;
    }

    public HadoopShims.DirectDecompressorShim getDirectDecompressor(HadoopShims.DirectCompressionType codec) {
        if (this.zeroCopy) {
            return ZeroCopyShims.getDirectDecompressor(codec);
        }
        return null;
    }

    public Configuration getConfiguration(org.apache.hadoop.mapreduce.JobContext context) {
        return context.getConfiguration();
    }

    public FileSystem getNonCachedFileSystem(URI uri, Configuration conf) throws IOException {
        return FileSystem.newInstance((URI)uri, (Configuration)conf);
    }

    class ProxyFileSystem23
    extends ProxyFileSystem {
        public ProxyFileSystem23(FileSystem fs) {
            super(fs);
        }

        public ProxyFileSystem23(FileSystem fs, URI uri) {
            super(fs, uri);
        }

        public RemoteIterator<LocatedFileStatus> listLocatedStatus(final Path f) throws FileNotFoundException, IOException {
            return new RemoteIterator<LocatedFileStatus>(){
                private RemoteIterator<LocatedFileStatus> stats;
                {
                    this.stats = ProxyFileSystem23.super.listLocatedStatus(ProxyFileSystem23.super.swizzleParamPath(f));
                }

                public boolean hasNext() throws IOException {
                    return this.stats.hasNext();
                }

                public LocatedFileStatus next() throws IOException {
                    LocatedFileStatus result = (LocatedFileStatus)this.stats.next();
                    return new LocatedFileStatus(ProxyFileSystem23.super.swizzleFileStatus((FileStatus)result, false), result.getBlockLocations());
                }
            };
        }
    }

    private final class HCatHadoopShims23
    implements HadoopShims.HCatHadoopShims {
        private HCatHadoopShims23() {
        }

        public TaskID createTaskID() {
            return new TaskID("", 0, TaskType.MAP, 0);
        }

        public org.apache.hadoop.mapreduce.TaskAttemptID createTaskAttemptID() {
            return new org.apache.hadoop.mapreduce.TaskAttemptID("", 0, TaskType.MAP, 0, 0);
        }

        public TaskAttemptContext createTaskAttemptContext(Configuration conf, org.apache.hadoop.mapreduce.TaskAttemptID taskId) {
            return new TaskAttemptContextImpl((Configuration)(conf instanceof JobConf ? new JobConf(conf) : conf), taskId);
        }

        public org.apache.hadoop.mapred.TaskAttemptContext createTaskAttemptContext(JobConf conf, TaskAttemptID taskId, Progressable progressable) {
            org.apache.hadoop.mapred.TaskAttemptContext newContext = null;
            try {
                Constructor construct = org.apache.hadoop.mapred.TaskAttemptContextImpl.class.getDeclaredConstructor(JobConf.class, TaskAttemptID.class, Reporter.class);
                construct.setAccessible(true);
                newContext = (org.apache.hadoop.mapred.TaskAttemptContext)construct.newInstance(new JobConf((Configuration)conf), taskId, (Reporter)progressable);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return newContext;
        }

        public org.apache.hadoop.mapreduce.JobContext createJobContext(Configuration conf, JobID jobId) {
            return new org.apache.hadoop.mapreduce.task.JobContextImpl((Configuration)(conf instanceof JobConf ? new JobConf(conf) : conf), jobId);
        }

        public JobContext createJobContext(JobConf conf, JobID jobId, Progressable progressable) {
            return new JobContextImpl(new JobConf((Configuration)conf), jobId, (Progressable)((Reporter)progressable));
        }

        public void commitJob(OutputFormat outputFormat, Job job) throws IOException {
        }

        public void abortJob(OutputFormat outputFormat, Job job) throws IOException {
        }

        public InetSocketAddress getResourceManagerAddress(Configuration conf) {
            String addr = conf.get("yarn.resourcemanager.address", "localhost:8032");
            return NetUtils.createSocketAddr((String)addr);
        }

        public String getPropertyName(HadoopShims.HCatHadoopShims.PropertyName name) {
            switch (name) {
                case CACHE_ARCHIVES: {
                    return "mapreduce.job.cache.archives";
                }
                case CACHE_FILES: {
                    return "mapreduce.job.cache.files";
                }
                case CACHE_SYMLINK: {
                    return "mapreduce.job.cache.symlink.create";
                }
            }
            return "";
        }

        public boolean isFileInHDFS(FileSystem fs, Path path) throws IOException {
            return "hdfs".equals(fs.resolvePath(path).toUri().getScheme());
        }
    }

    public class MiniDFSShim
    implements HadoopShims.MiniDFSShim {
        private final MiniDFSCluster cluster;

        public MiniDFSShim(MiniDFSCluster cluster) {
            this.cluster = cluster;
        }

        public FileSystem getFileSystem() throws IOException {
            return this.cluster.getFileSystem();
        }

        public void shutdown() {
            this.cluster.shutdown();
        }
    }

    public class MiniTezShim
    extends MiniMrShim {
        private final MiniTezCluster mr;
        private final Configuration conf;

        public MiniTezShim(Configuration conf, int numberOfTaskTrackers, String nameNode, int numDir) throws IOException {
            this.mr = new MiniTezCluster("hive", numberOfTaskTrackers);
            conf.set("fs.defaultFS", nameNode);
            conf.set("yarn.app.mapreduce.am.staging-dir", "/apps_staging_dir");
            this.mr.init(conf);
            this.mr.start();
            this.conf = this.mr.getConfig();
        }

        @Override
        public int getJobTrackerPort() throws UnsupportedOperationException {
            String address = this.conf.get("yarn.resourcemanager.address");
            if (StringUtils.isBlank((String)(address = StringUtils.substringAfterLast((String)address, (String)":")))) {
                throw new IllegalArgumentException("Invalid YARN resource manager port.");
            }
            return Integer.parseInt(address);
        }

        @Override
        public void shutdown() throws IOException {
            this.mr.stop();
        }

        @Override
        public void setupConfiguration(Configuration conf) {
            Configuration config = this.mr.getConfig();
            for (Map.Entry pair : config) {
                conf.set((String)pair.getKey(), (String)pair.getValue());
            }
            Path jarPath = new Path("hdfs:///user/hive");
            Path hdfsPath = new Path("hdfs:///user/");
            try {
                FileSystem fs = Hadoop23Shims.this.cluster.getFileSystem();
                jarPath = fs.makeQualified(jarPath);
                conf.set("hive.jar.directory", jarPath.toString());
                fs.mkdirs(jarPath);
                hdfsPath = fs.makeQualified(hdfsPath);
                conf.set("hive.user.install.directory", hdfsPath.toString());
                fs.mkdirs(hdfsPath);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public class MiniMrShim
    implements HadoopShims.MiniMrShim {
        private final MiniMRCluster mr;
        private final Configuration conf;

        public MiniMrShim() {
            this.mr = null;
            this.conf = null;
        }

        public MiniMrShim(Configuration conf, int numberOfTaskTrackers, String nameNode, int numDir) throws IOException {
            this.conf = conf;
            JobConf jConf = new JobConf(conf);
            jConf.set("yarn.scheduler.capacity.root.queues", "default");
            jConf.set("yarn.scheduler.capacity.root.default.capacity", "100");
            this.mr = new MiniMRCluster(numberOfTaskTrackers, nameNode, numDir, null, null, jConf);
        }

        public int getJobTrackerPort() throws UnsupportedOperationException {
            String address = this.conf.get("yarn.resourcemanager.address");
            if (StringUtils.isBlank((String)(address = StringUtils.substringAfterLast((String)address, (String)":")))) {
                throw new IllegalArgumentException("Invalid YARN resource manager port.");
            }
            return Integer.parseInt(address);
        }

        public void shutdown() throws IOException {
            this.mr.shutdown();
        }

        public void setupConfiguration(Configuration conf) {
            JobConf jConf = this.mr.createJobConf();
            for (Map.Entry pair : jConf) {
                conf.set((String)pair.getKey(), (String)pair.getValue());
            }
        }
    }
}

