/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestFactory;
import org.apache.hc.core5.http.config.H1Config;
import org.apache.hc.core5.http.impl.nio.DefaultHttpRequestFactory;
import org.apache.hc.core5.http.impl.nio.DefaultHttpRequestParser;
import org.apache.hc.core5.http.message.LazyLineParser;
import org.apache.hc.core5.http.message.LineParser;
import org.apache.hc.core5.http.nio.NHttpMessageParser;
import org.apache.hc.core5.http.nio.NHttpMessageParserFactory;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpRequestParserFactory
implements NHttpMessageParserFactory<HttpRequest> {
    public static final DefaultHttpRequestParserFactory INSTANCE = new DefaultHttpRequestParserFactory();
    private final H1Config h1Config;
    private final LineParser lineParser;
    private final HttpRequestFactory<HttpRequest> requestFactory;

    public DefaultHttpRequestParserFactory(H1Config h1Config, HttpRequestFactory<HttpRequest> requestFactory, LineParser lineParser) {
        this.h1Config = h1Config != null ? h1Config : H1Config.DEFAULT;
        this.requestFactory = requestFactory != null ? requestFactory : DefaultHttpRequestFactory.INSTANCE;
        this.lineParser = lineParser != null ? lineParser : LazyLineParser.INSTANCE;
    }

    public DefaultHttpRequestParserFactory(H1Config h1Config) {
        this(h1Config, null, null);
    }

    public DefaultHttpRequestParserFactory() {
        this(null);
    }

    @Override
    public NHttpMessageParser<HttpRequest> create() {
        return new DefaultHttpRequestParser<HttpRequest>(this.requestFactory, this.lineParser, this.h1Config);
    }
}

