/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpResponseFactory;
import org.apache.hc.core5.http.config.H1Config;
import org.apache.hc.core5.http.impl.nio.DefaultHttpResponseFactory;
import org.apache.hc.core5.http.impl.nio.DefaultHttpResponseParser;
import org.apache.hc.core5.http.message.LazyLaxLineParser;
import org.apache.hc.core5.http.message.LineParser;
import org.apache.hc.core5.http.nio.NHttpMessageParser;
import org.apache.hc.core5.http.nio.NHttpMessageParserFactory;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseParserFactory
implements NHttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final H1Config h1Config;
    private final HttpResponseFactory<HttpResponse> responseFactory;
    private final LineParser lineParser;

    public DefaultHttpResponseParserFactory(H1Config h1Config, HttpResponseFactory<HttpResponse> responseFactory, LineParser lineParser) {
        this.h1Config = h1Config != null ? h1Config : H1Config.DEFAULT;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
        this.lineParser = lineParser != null ? lineParser : LazyLaxLineParser.INSTANCE;
    }

    public DefaultHttpResponseParserFactory(H1Config h1Config) {
        this(h1Config, null, null);
    }

    public DefaultHttpResponseParserFactory() {
        this(null);
    }

    @Override
    public NHttpMessageParser<HttpResponse> create() {
        return new DefaultHttpResponseParser<HttpResponse>(this.responseFactory, this.lineParser, this.h1Config);
    }
}

