/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.pool;

import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Experimental;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.BasicFuture;
import org.apache.hc.core5.concurrent.Cancellable;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.ModalCloseable;
import org.apache.hc.core5.pool.ConnPoolListener;
import org.apache.hc.core5.pool.ConnPoolStats;
import org.apache.hc.core5.pool.ManagedConnPool;
import org.apache.hc.core5.pool.PoolEntry;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.pool.PoolStats;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;
import org.apache.hc.core5.util.Deadline;
import org.apache.hc.core5.util.DeadlineTimeoutException;
import org.apache.hc.core5.util.LangUtils;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

@Contract(threading=ThreadingBehavior.SAFE)
@Experimental
public class LaxConnPool<T, C extends ModalCloseable>
implements ManagedConnPool<T, C> {
    private final TimeValue timeToLive;
    private final ConnPoolListener<T> connPoolListener;
    private final PoolReusePolicy policy;
    private final ConcurrentMap<T, PerRoutePool<T, C>> routeToPool;
    private final AtomicBoolean isShutDown;
    private volatile int defaultMaxPerRoute;

    public LaxConnPool(int defaultMaxPerRoute, TimeValue timeToLive, PoolReusePolicy policy, ConnPoolListener<T> connPoolListener) {
        Args.positive(defaultMaxPerRoute, "Max per route value");
        this.timeToLive = TimeValue.defaultsToNegativeOneMillisecond(timeToLive);
        this.connPoolListener = connPoolListener;
        this.policy = policy != null ? policy : PoolReusePolicy.LIFO;
        this.routeToPool = new ConcurrentHashMap<T, PerRoutePool<T, C>>();
        this.isShutDown = new AtomicBoolean(false);
        this.defaultMaxPerRoute = defaultMaxPerRoute;
    }

    public LaxConnPool(int defaultMaxPerRoute) {
        this(defaultMaxPerRoute, TimeValue.NEG_ONE_MILLISECONDS, PoolReusePolicy.LIFO, null);
    }

    public boolean isShutdown() {
        return this.isShutDown.get();
    }

    @Override
    public void close(CloseMode closeMode) {
        if (this.isShutDown.compareAndSet(false, true)) {
            for (PerRoutePool routePool : this.routeToPool.values()) {
                routePool.shutdown(closeMode);
            }
            this.routeToPool.clear();
        }
    }

    @Override
    public void close() {
        this.close(CloseMode.GRACEFUL);
    }

    private PerRoutePool<T, C> getPool(T route) {
        PerRoutePool newRoutePool;
        PerRoutePool routePool = (PerRoutePool)this.routeToPool.get(route);
        if (routePool == null && (routePool = this.routeToPool.putIfAbsent(route, newRoutePool = new PerRoutePool(route, this.defaultMaxPerRoute, this.timeToLive, this.policy, this, this.connPoolListener))) == null) {
            routePool = newRoutePool;
        }
        return routePool;
    }

    @Override
    public Future<PoolEntry<T, C>> lease(T route, Object state, Timeout requestTimeout, FutureCallback<PoolEntry<T, C>> callback) {
        Args.notNull(route, "Route");
        Asserts.check(!this.isShutDown.get(), "Connection pool shut down");
        PerRoutePool<T, C> routePool = this.getPool(route);
        return routePool.lease(state, requestTimeout, callback);
    }

    public Future<PoolEntry<T, C>> lease(T route, Object state) {
        return this.lease(route, state, Timeout.DISABLED, null);
    }

    @Override
    public void release(PoolEntry<T, C> entry, boolean reusable) {
        if (entry == null) {
            return;
        }
        if (this.isShutDown.get()) {
            return;
        }
        PerRoutePool<T, C> routePool = this.getPool(entry.getRoute());
        if (this.connPoolListener != null) {
            this.connPoolListener.onLease(entry.getRoute(), this);
        }
        routePool.release(entry, reusable);
    }

    public void validatePendingRequests() {
        for (PerRoutePool routePool : this.routeToPool.values()) {
            routePool.validatePendingRequests();
        }
    }

    @Override
    public void setMaxTotal(int max) {
    }

    @Override
    public int getMaxTotal() {
        return 0;
    }

    @Override
    public void setDefaultMaxPerRoute(int max) {
        Args.positive(max, "Max value");
        this.defaultMaxPerRoute = max;
    }

    @Override
    public int getDefaultMaxPerRoute() {
        return this.defaultMaxPerRoute;
    }

    @Override
    public void setMaxPerRoute(T route, int max) {
        Args.notNull(route, "Route");
        PerRoutePool<T, C> routePool = this.getPool(route);
        routePool.setMax(max > -1 ? max : this.defaultMaxPerRoute);
    }

    @Override
    public int getMaxPerRoute(T route) {
        Args.notNull(route, "Route");
        PerRoutePool<T, C> routePool = this.getPool(route);
        return routePool.getMax();
    }

    @Override
    public PoolStats getTotalStats() {
        int leasedTotal = 0;
        int pendingTotal = 0;
        int availableTotal = 0;
        int maxTotal = 0;
        for (PerRoutePool routePool : this.routeToPool.values()) {
            leasedTotal += routePool.getLeasedCount();
            pendingTotal += routePool.getPendingCount();
            availableTotal += routePool.getAvailableCount();
            maxTotal += routePool.getMax();
        }
        return new PoolStats(leasedTotal, pendingTotal, availableTotal, maxTotal);
    }

    @Override
    public PoolStats getStats(T route) {
        Args.notNull(route, "Route");
        PerRoutePool<T, C> routePool = this.getPool(route);
        return new PoolStats(routePool.getLeasedCount(), routePool.getPendingCount(), routePool.getAvailableCount(), routePool.getMax());
    }

    @Override
    public Set<T> getRoutes() {
        return new HashSet(this.routeToPool.keySet());
    }

    public void enumAvailable(Callback<PoolEntry<T, C>> callback) {
        for (PerRoutePool routePool : this.routeToPool.values()) {
            routePool.enumAvailable(callback);
        }
    }

    public void enumLeased(Callback<PoolEntry<T, C>> callback) {
        for (PerRoutePool routePool : this.routeToPool.values()) {
            routePool.enumLeased(callback);
        }
    }

    @Override
    public void closeIdle(TimeValue idleTime) {
        final long deadline = System.currentTimeMillis() - (TimeValue.isPositive(idleTime) ? idleTime.toMillis() : 0L);
        this.enumAvailable(new Callback<PoolEntry<T, C>>(){

            @Override
            public void execute(PoolEntry<T, C> entry) {
                if (entry.getUpdated() <= deadline) {
                    entry.discardConnection(CloseMode.GRACEFUL);
                }
            }
        });
    }

    @Override
    public void closeExpired() {
        final long now = System.currentTimeMillis();
        this.enumAvailable(new Callback<PoolEntry<T, C>>(){

            @Override
            public void execute(PoolEntry<T, C> entry) {
                if (entry.getExpiryDeadline().isBefore(now)) {
                    entry.discardConnection(CloseMode.GRACEFUL);
                }
            }
        });
    }

    public String toString() {
        PoolStats totalStats = this.getTotalStats();
        StringBuilder buffer = new StringBuilder();
        buffer.append("[leased: ");
        buffer.append(totalStats.getLeased());
        buffer.append("][available: ");
        buffer.append(totalStats.getAvailable());
        buffer.append("][pending: ");
        buffer.append(totalStats.getPending());
        buffer.append("]");
        return buffer.toString();
    }

    static class PerRoutePool<T, C extends ModalCloseable> {
        private final T route;
        private final TimeValue timeToLive;
        private final PoolReusePolicy policy;
        private final ConnPoolStats<T> connPoolStats;
        private final ConnPoolListener<T> connPoolListener;
        private final ConcurrentMap<PoolEntry<T, C>, Boolean> leased;
        private final Deque<PoolEntry<T, C>> available;
        private final Deque<LeaseRequest<T, C>> pending;
        private final AtomicBoolean terminated;
        private volatile int max;

        PerRoutePool(T route, int max, TimeValue timeToLive, PoolReusePolicy policy, ConnPoolStats<T> connPoolStats, ConnPoolListener<T> connPoolListener) {
            this.route = route;
            this.timeToLive = timeToLive;
            this.policy = policy;
            this.connPoolStats = connPoolStats;
            this.connPoolListener = connPoolListener;
            this.leased = new ConcurrentHashMap<PoolEntry<T, C>, Boolean>();
            this.available = new ConcurrentLinkedDeque<PoolEntry<T, C>>();
            this.pending = new ConcurrentLinkedDeque<LeaseRequest<T, C>>();
            this.terminated = new AtomicBoolean(false);
            this.max = max;
        }

        public void shutdown(CloseMode closeMode) {
            if (this.terminated.compareAndSet(false, true)) {
                LeaseRequest<T, C> leaseRequest;
                PoolEntry<T, C> availableEntry;
                while ((availableEntry = this.available.poll()) != null) {
                    availableEntry.discardConnection(closeMode);
                }
                for (PoolEntry entry : this.leased.keySet()) {
                    entry.discardConnection(closeMode);
                }
                this.leased.clear();
                while ((leaseRequest = this.pending.poll()) != null) {
                    leaseRequest.cancel();
                }
            }
        }

        private void addLeased(PoolEntry<T, C> entry) {
            if (this.leased.putIfAbsent(entry, Boolean.TRUE) != null) {
                throw new IllegalStateException("Pool entry already present in the set of leased entries");
            }
            if (this.connPoolListener != null) {
                this.connPoolListener.onLease(this.route, this.connPoolStats);
            }
        }

        private void removeLeased(PoolEntry<T, C> entry) {
            if (this.connPoolListener != null) {
                this.connPoolListener.onRelease(this.route, this.connPoolStats);
            }
            if (!this.leased.remove(entry, Boolean.TRUE)) {
                throw new IllegalStateException("Pool entry is not present in the set of leased entries");
            }
        }

        private PoolEntry<T, C> getAvailableEntry(Object state) {
            PoolEntry<T, C> entry = this.available.poll();
            if (entry != null) {
                if (entry.getExpiryDeadline().isExpired()) {
                    entry.discardConnection(CloseMode.GRACEFUL);
                }
                if (!LangUtils.equals(entry.getState(), state)) {
                    entry.discardConnection(CloseMode.GRACEFUL);
                }
            }
            return entry;
        }

        public Future<PoolEntry<T, C>> lease(Object state, Timeout requestTimeout, FutureCallback<PoolEntry<T, C>> callback) {
            Asserts.check(!this.terminated.get(), "Connection pool shut down");
            BasicFuture future = new BasicFuture(callback);
            PoolEntry<T, C> availableEntry = this.getAvailableEntry(state);
            if (availableEntry != null) {
                this.addLeased(availableEntry);
                future.completed(availableEntry);
            } else if (this.pending.isEmpty() && this.leased.size() < this.max) {
                PoolEntry entry = new PoolEntry(this.route, this.timeToLive);
                this.addLeased(entry);
                future.completed(entry);
            } else {
                this.pending.add(new LeaseRequest<T, C>(state, requestTimeout, future));
            }
            return future;
        }

        public void release(PoolEntry<T, C> releasedEntry, boolean reusable) {
            LeaseRequest leaseRequest;
            this.removeLeased(releasedEntry);
            if (!reusable || releasedEntry.getExpiryDeadline().isExpired()) {
                releasedEntry.discardConnection(CloseMode.GRACEFUL);
            }
            if (releasedEntry.hasConnection()) {
                switch (this.policy) {
                    case LIFO: {
                        this.available.addFirst(releasedEntry);
                        break;
                    }
                    case FIFO: {
                        this.available.addLast(releasedEntry);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected ConnPoolPolicy value: " + (Object)((Object)this.policy));
                    }
                }
            }
            while ((leaseRequest = this.pending.poll()) != null) {
                if (leaseRequest.isDone()) continue;
                Object state = leaseRequest.getState();
                Deadline deadline = leaseRequest.getDeadline();
                if (deadline.isExpired()) {
                    leaseRequest.failed(DeadlineTimeoutException.from(deadline));
                    continue;
                }
                PoolEntry<T, C> availableEntry = this.getAvailableEntry(state);
                if (availableEntry != null) {
                    this.addLeased(availableEntry);
                    leaseRequest.completed(availableEntry);
                    break;
                }
                if (this.leased.size() >= this.max) break;
                PoolEntry newEntry = new PoolEntry(this.route, this.timeToLive);
                this.addLeased(newEntry);
                leaseRequest.completed(newEntry);
                break;
            }
        }

        public void validatePendingRequests() {
            Iterator<LeaseRequest<T, C>> it = this.pending.iterator();
            while (it.hasNext()) {
                LeaseRequest<T, C> request = it.next();
                BasicFuture<PoolEntry<T, C>> future = request.getFuture();
                if (future.isCancelled() && !request.isDone()) {
                    it.remove();
                    continue;
                }
                Deadline deadline = request.getDeadline();
                if (deadline.isExpired()) {
                    request.failed(DeadlineTimeoutException.from(deadline));
                }
                if (!request.isDone()) continue;
                it.remove();
            }
        }

        public final T getRoute() {
            return this.route;
        }

        public int getMax() {
            return this.max;
        }

        public void setMax(int max) {
            this.max = max;
        }

        public int getPendingCount() {
            return this.pending.size();
        }

        public int getLeasedCount() {
            return this.leased.size();
        }

        public int getAvailableCount() {
            return this.available.size();
        }

        public void enumAvailable(Callback<PoolEntry<T, C>> callback) {
            Iterator<PoolEntry<T, C>> it = this.available.iterator();
            while (it.hasNext()) {
                PoolEntry<T, C> entry = it.next();
                callback.execute(entry);
                if (entry.hasConnection()) continue;
                it.remove();
            }
        }

        public void enumLeased(Callback<PoolEntry<T, C>> callback) {
            Iterator it = this.leased.keySet().iterator();
            while (it.hasNext()) {
                PoolEntry entry = (PoolEntry)it.next();
                callback.execute(entry);
                if (entry.hasConnection()) continue;
                it.remove();
            }
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("[route: ");
            buffer.append(this.route);
            buffer.append("][leased: ");
            buffer.append(this.leased.size());
            buffer.append("][available: ");
            buffer.append(this.available.size());
            buffer.append("][pending: ");
            buffer.append(this.pending.size());
            buffer.append("]");
            return buffer.toString();
        }
    }

    static class LeaseRequest<T, C extends ModalCloseable>
    implements Cancellable {
        private final Object state;
        private final Deadline deadline;
        private final BasicFuture<PoolEntry<T, C>> future;

        LeaseRequest(Object state, Timeout requestTimeout, BasicFuture<PoolEntry<T, C>> future) {
            this.state = state;
            this.deadline = Deadline.calculate(requestTimeout);
            this.future = future;
        }

        BasicFuture<PoolEntry<T, C>> getFuture() {
            return this.future;
        }

        public Object getState() {
            return this.state;
        }

        public Deadline getDeadline() {
            return this.deadline;
        }

        public boolean isDone() {
            return this.future.isDone();
        }

        public void completed(PoolEntry<T, C> result) {
            this.future.completed(result);
        }

        public void failed(Exception ex) {
            this.future.failed(ex);
        }

        @Override
        public boolean cancel() {
            return this.future.cancel();
        }
    }
}

