/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor.ssl;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.ssl.SSLBufferMode;
import org.apache.hc.core5.reactor.ssl.SSLManagedBuffer;
import org.apache.hc.core5.reactor.ssl.SSLMode;
import org.apache.hc.core5.reactor.ssl.SSLSessionInitializer;
import org.apache.hc.core5.reactor.ssl.SSLSessionVerifier;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;
import org.apache.hc.core5.util.ReflectionUtils;
import org.apache.hc.core5.util.Timeout;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
@Internal
public class SSLIOSession
implements IOSession {
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private final NamedEndpoint targetEndpoint;
    private final IOSession session;
    private final SSLEngine sslEngine;
    private final SSLManagedBuffer inEncrypted;
    private final SSLManagedBuffer outEncrypted;
    private final SSLManagedBuffer inPlain;
    private final ByteChannel channel;
    private final SSLSessionInitializer initializer;
    private final SSLSessionVerifier verifier;
    private final Callback<SSLIOSession> callback;
    private final AtomicLong bytesReadCount;
    private int appEventMask;
    private boolean endOfStream;
    private volatile SSLMode sslMode;
    private volatile int status;
    private volatile boolean initialized;
    private volatile Timeout socketTimeout;
    private TlsDetails tlsDetails;

    public SSLIOSession(NamedEndpoint targetEndpoint, IOSession session, SSLMode sslMode, SSLContext sslContext, SSLSessionInitializer initializer, SSLSessionVerifier verifier, Callback<SSLIOSession> callback) {
        this(targetEndpoint, session, sslMode, sslContext, SSLBufferMode.STATIC, initializer, verifier, callback, null);
    }

    public SSLIOSession(NamedEndpoint targetEndpoint, IOSession session, SSLMode sslMode, SSLContext sslContext, SSLBufferMode sslBufferMode, SSLSessionInitializer initializer, SSLSessionVerifier verifier, Callback<SSLIOSession> callback, Timeout connectTimeout) {
        Args.notNull(session, "IO session");
        Args.notNull(sslContext, "SSL context");
        this.targetEndpoint = targetEndpoint;
        this.session = session;
        this.sslMode = sslMode;
        this.initializer = initializer;
        this.verifier = verifier;
        this.callback = callback;
        this.appEventMask = session.getEventMask();
        this.sslEngine = this.sslMode == SSLMode.CLIENT && targetEndpoint != null ? sslContext.createSSLEngine(targetEndpoint.getHostName(), targetEndpoint.getPort()) : sslContext.createSSLEngine();
        SSLSession sslSession = this.sslEngine.getSession();
        int netBufferSize = sslSession.getPacketBufferSize();
        this.inEncrypted = SSLManagedBuffer.create(sslBufferMode, netBufferSize);
        this.outEncrypted = SSLManagedBuffer.create(sslBufferMode, netBufferSize);
        int appBufferSize = sslSession.getApplicationBufferSize();
        this.inPlain = SSLManagedBuffer.create(sslBufferMode, appBufferSize);
        this.channel = new ByteChannel(){

            @Override
            public int write(ByteBuffer src) throws IOException {
                return SSLIOSession.this.writePlain(src);
            }

            @Override
            public int read(ByteBuffer dst) throws IOException {
                return SSLIOSession.this.readPlain(dst);
            }

            @Override
            public void close() throws IOException {
                SSLIOSession.this.close();
            }

            @Override
            public boolean isOpen() {
                return !SSLIOSession.this.isClosed();
            }
        };
        this.bytesReadCount = new AtomicLong(0L);
        this.socketTimeout = this.session.getSocketTimeout();
        if (connectTimeout != null) {
            this.session.setSocketTimeout(connectTimeout);
        }
    }

    @Override
    public String getId() {
        return this.session.getId();
    }

    @Override
    public Lock getLock() {
        return this.session.getLock();
    }

    @Override
    public Lock lock() {
        return this.session.getLock();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws SSLException {
        Asserts.check(!this.initialized, "SSL I/O session already initialized");
        this.session.getLock().lock();
        try {
            if (this.status >= 1) {
                return;
            }
            switch (this.sslMode) {
                case CLIENT: {
                    this.sslEngine.setUseClientMode(true);
                    break;
                }
                case SERVER: {
                    this.sslEngine.setUseClientMode(false);
                }
            }
            if (this.initializer != null) {
                this.initializer.initialize(this.targetEndpoint, this.sslEngine);
            }
            this.initialized = true;
            this.sslEngine.beginHandshake();
            this.inEncrypted.release();
            this.outEncrypted.release();
            this.inPlain.release();
            this.doHandshake();
        }
        finally {
            this.session.getLock().unlock();
        }
    }

    public TlsDetails getTlsDetails() {
        return this.tlsDetails;
    }

    private SSLException convert(RuntimeException ex) {
        Throwable cause = ex.getCause();
        if (cause == null) {
            cause = ex;
        }
        return new SSLException(cause);
    }

    private SSLEngineResult doWrap(ByteBuffer src, ByteBuffer dst) throws SSLException {
        try {
            return this.sslEngine.wrap(src, dst);
        }
        catch (RuntimeException ex) {
            throw this.convert(ex);
        }
    }

    private SSLEngineResult doUnwrap(ByteBuffer src, ByteBuffer dst) throws SSLException {
        try {
            return this.sslEngine.unwrap(src, dst);
        }
        catch (RuntimeException ex) {
            throw this.convert(ex);
        }
    }

    private void doRunTask() throws SSLException {
        try {
            Runnable r = this.sslEngine.getDelegatedTask();
            if (r != null) {
                r.run();
            }
        }
        catch (RuntimeException ex) {
            throw this.convert(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHandshake() throws SSLException {
        boolean handshaking = true;
        SSLEngineResult result = null;
        while (handshaking) {
            switch (this.sslEngine.getHandshakeStatus()) {
                case NEED_WRAP: {
                    ByteBuffer outEncryptedBuf = this.outEncrypted.acquire();
                    result = this.doWrap(EMPTY_BUFFER, outEncryptedBuf);
                    if (result.getStatus() == SSLEngineResult.Status.OK && result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_WRAP) break;
                    handshaking = false;
                    break;
                }
                case NEED_UNWRAP: {
                    ByteBuffer inEncryptedBuf = this.inEncrypted.acquire();
                    ByteBuffer inPlainBuf = this.inPlain.acquire();
                    inEncryptedBuf.flip();
                    result = this.doUnwrap(inEncryptedBuf, inPlainBuf);
                    inEncryptedBuf.compact();
                    try {
                        if (!inEncryptedBuf.hasRemaining() && result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                            throw new SSLException("Input buffer is full");
                        }
                    }
                    finally {
                        if (inEncryptedBuf.position() == 0) {
                            this.inEncrypted.release();
                        }
                    }
                    if (this.status >= 1) {
                        this.inPlain.release();
                    }
                    if (result.getStatus() == SSLEngineResult.Status.OK) break;
                    handshaking = false;
                    break;
                }
                case NEED_TASK: {
                    this.doRunTask();
                    break;
                }
                case NOT_HANDSHAKING: {
                    handshaking = false;
                    break;
                }
                case FINISHED: {
                    this.session.setSocketTimeout(this.socketTimeout);
                }
            }
        }
        if (result != null && result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
            if (this.verifier != null) {
                this.tlsDetails = this.verifier.verify(this.targetEndpoint, this.sslEngine);
            }
            if (this.tlsDetails == null) {
                SSLSession sslSession = this.sslEngine.getSession();
                String applicationProtocol = ReflectionUtils.callGetter(this.sslEngine, "ApplicationProtocol", String.class);
                this.tlsDetails = new TlsDetails(sslSession, applicationProtocol);
            }
            if (this.callback != null) {
                this.callback.execute(this);
            }
        }
    }

    private void updateEventMask() {
        int oldMask;
        if (this.status == 0 && (this.endOfStream || this.sslEngine.isInboundDone())) {
            this.status = 1;
        }
        if (this.status == 1 && !this.outEncrypted.hasData()) {
            this.sslEngine.closeOutbound();
        }
        if (this.status == 1 && this.sslEngine.isOutboundDone() && (this.endOfStream || this.sslEngine.isInboundDone())) {
            this.status = Integer.MAX_VALUE;
        }
        if (this.status <= 1 && this.endOfStream && this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
            this.status = Integer.MAX_VALUE;
        }
        if (this.status == Integer.MAX_VALUE) {
            this.session.close();
            return;
        }
        int newMask = oldMask = this.session.getEventMask();
        switch (this.sslEngine.getHandshakeStatus()) {
            case NEED_WRAP: {
                newMask = 5;
                break;
            }
            case NEED_UNWRAP: {
                newMask = 1;
                break;
            }
            case NOT_HANDSHAKING: {
                newMask = this.appEventMask;
                break;
            }
            case NEED_TASK: {
                break;
            }
        }
        if (this.endOfStream) {
            newMask &= 0xFFFFFFFE;
        }
        if (this.outEncrypted.hasData()) {
            newMask |= 4;
        }
        if (oldMask != newMask) {
            this.session.setEventMask(newMask);
        }
    }

    private int sendEncryptedData() throws IOException {
        if (!this.outEncrypted.hasData()) {
            return this.session.channel().write(EMPTY_BUFFER);
        }
        ByteBuffer outEncryptedBuf = this.outEncrypted.acquire();
        int bytesWritten = 0;
        if (outEncryptedBuf.position() > 0) {
            outEncryptedBuf.flip();
            bytesWritten = this.session.channel().write(outEncryptedBuf);
            outEncryptedBuf.compact();
        }
        if (outEncryptedBuf.position() == 0) {
            this.outEncrypted.release();
        }
        return bytesWritten;
    }

    private int receiveEncryptedData() throws IOException {
        if (this.endOfStream) {
            return -1;
        }
        ByteBuffer inEncryptedBuf = this.inEncrypted.acquire();
        int bytesRead = this.session.channel().read(inEncryptedBuf);
        if (inEncryptedBuf.position() == 0) {
            this.inEncrypted.release();
        }
        if (bytesRead == -1) {
            this.endOfStream = true;
        }
        return bytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean decryptData() throws SSLException {
        boolean decrypted = false;
        while (this.inEncrypted.hasData()) {
            ByteBuffer inEncryptedBuf = this.inEncrypted.acquire();
            ByteBuffer inPlainBuf = this.inPlain.acquire();
            inEncryptedBuf.flip();
            SSLEngineResult result = this.doUnwrap(inEncryptedBuf, inPlainBuf);
            inEncryptedBuf.compact();
            try {
                if (!inEncryptedBuf.hasRemaining() && result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    throw new SSLException("Unable to complete SSL handshake");
                }
                SSLEngineResult.Status status = result.getStatus();
                if (status == SSLEngineResult.Status.OK) {
                    decrypted = true;
                    continue;
                }
                if (status == SSLEngineResult.Status.BUFFER_UNDERFLOW && this.endOfStream) {
                    throw new SSLException("Unable to decrypt incoming data due to unexpected end of stream");
                }
                break;
            }
            finally {
                if (this.inEncrypted.acquire().position() != 0) continue;
                this.inEncrypted.release();
            }
        }
        if (this.sslEngine.isInboundDone()) {
            this.endOfStream = true;
        }
        return decrypted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAppInputReady() throws IOException {
        this.session.getLock().lock();
        try {
            do {
                this.receiveEncryptedData();
                this.doHandshake();
                SSLEngineResult.HandshakeStatus status = this.sslEngine.getHandshakeStatus();
                if (status != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && status != SSLEngineResult.HandshakeStatus.FINISHED) continue;
                this.decryptData();
            } while (this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK);
            boolean bl = this.inPlain.hasData() || this.endOfStream && this.status == 0;
            return bl;
        }
        finally {
            this.session.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAppOutputReady() throws IOException {
        this.session.getLock().lock();
        try {
            boolean bl = (this.appEventMask & 4) > 0 && this.status == 0 && this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
            return bl;
        }
        finally {
            this.session.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inboundTransport() throws IOException {
        this.session.getLock().lock();
        try {
            this.updateEventMask();
        }
        finally {
            this.session.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outboundTransport() throws IOException {
        this.session.getLock().lock();
        try {
            if (this.session.isClosed()) {
                return;
            }
            this.sendEncryptedData();
            this.doHandshake();
            this.updateEventMask();
        }
        finally {
            this.session.getLock().unlock();
        }
    }

    public boolean isInboundDone() {
        return this.sslEngine.isInboundDone();
    }

    public boolean isOutboundDone() {
        return this.sslEngine.isOutboundDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writePlain(ByteBuffer src) throws IOException {
        Args.notNull(src, "Byte buffer");
        this.session.getLock().lock();
        try {
            if (this.status != 0) {
                throw new ClosedChannelException();
            }
            if (!this.initialized) {
                int n = 0;
                return n;
            }
            ByteBuffer outEncryptedBuf = this.outEncrypted.acquire();
            SSLEngineResult result = this.doWrap(src, outEncryptedBuf);
            if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
                this.status = Integer.MAX_VALUE;
            }
            int n = result.bytesConsumed();
            return n;
        }
        finally {
            this.session.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readPlain(ByteBuffer dst) {
        Args.notNull(dst, "Byte buffer");
        this.session.getLock().lock();
        try {
            if (!this.initialized) {
                int n = 0;
                return n;
            }
            if (this.inPlain.hasData()) {
                ByteBuffer inPlainBuf = this.inPlain.acquire();
                inPlainBuf.flip();
                int n = Math.min(inPlainBuf.remaining(), dst.remaining());
                for (int i = 0; i < n; ++i) {
                    dst.put(inPlainBuf.get());
                }
                inPlainBuf.compact();
                if (inPlainBuf.position() == 0) {
                    this.inPlain.release();
                }
                this.bytesReadCount.addAndGet(n);
                int n2 = n;
                return n2;
            }
            if (this.endOfStream) {
                int n = -1;
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.session.getLock().unlock();
        }
    }

    public void resetReadCount() {
        this.bytesReadCount.set(0L);
    }

    public long getReadCount() {
        return this.bytesReadCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.session.getLock().lock();
        try {
            if (this.status >= 1) {
                return;
            }
            this.status = 1;
            if (this.session.getSocketTimeout().isDisabled()) {
                this.session.setSocketTimeout(Timeout.ofMilliseconds(1000L));
            }
            try {
                this.updateEventMask();
            }
            catch (CancelledKeyException ex) {
                this.close(CloseMode.GRACEFUL);
            }
        }
        finally {
            this.session.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(CloseMode closeMode) {
        this.session.getLock().lock();
        try {
            if (this.status == Integer.MAX_VALUE) {
                return;
            }
            this.inEncrypted.release();
            this.outEncrypted.release();
            this.inPlain.release();
            this.status = Integer.MAX_VALUE;
            this.session.close(closeMode);
        }
        finally {
            this.session.getLock().unlock();
        }
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public boolean isClosed() {
        return this.status >= 1 || this.session.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(Command command, Command.Priority priority) {
        this.session.getLock().lock();
        try {
            this.session.enqueue(command, priority);
            this.setEvent(4);
        }
        finally {
            this.session.getLock().unlock();
        }
    }

    @Override
    public boolean hasCommands() {
        return this.session.hasCommands();
    }

    @Override
    public Command poll() {
        return this.session.poll();
    }

    @Override
    public ByteChannel channel() {
        return this.channel;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.session.getLocalAddress();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.session.getRemoteAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getEventMask() {
        this.session.getLock().lock();
        try {
            int n = this.appEventMask;
            return n;
        }
        finally {
            this.session.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEventMask(int ops) {
        this.session.getLock().lock();
        try {
            this.appEventMask = ops;
            this.updateEventMask();
        }
        finally {
            this.session.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEvent(int op) {
        this.session.getLock().lock();
        try {
            this.appEventMask |= op;
            this.updateEventMask();
        }
        finally {
            this.session.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearEvent(int op) {
        this.session.getLock().lock();
        try {
            this.appEventMask &= ~op;
            this.updateEventMask();
        }
        finally {
            this.session.getLock().unlock();
        }
    }

    @Override
    public Timeout getSocketTimeout() {
        return this.session.getSocketTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSocketTimeout(Timeout timeout) {
        this.socketTimeout = timeout;
        this.session.getLock().lock();
        try {
            if (this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
                this.session.setSocketTimeout(timeout);
            }
        }
        finally {
            this.session.getLock().unlock();
        }
    }

    @Override
    public void updateReadTime() {
        this.session.updateReadTime();
    }

    @Override
    public void updateWriteTime() {
        this.session.updateWriteTime();
    }

    @Override
    public long getLastReadTime() {
        return this.session.getLastReadTime();
    }

    @Override
    public long getLastWriteTime() {
        return this.session.getLastWriteTime();
    }

    private static void formatOps(StringBuilder buffer, int ops) {
        if ((ops & 1) > 0) {
            buffer.append('r');
        }
        if ((ops & 4) > 0) {
            buffer.append('w');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.session.getLock().lock();
        try {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.session);
            buffer.append("[");
            switch (this.status) {
                case 0: {
                    buffer.append("ACTIVE");
                    break;
                }
                case 1: {
                    buffer.append("CLOSING");
                    break;
                }
                case 0x7FFFFFFF: {
                    buffer.append("CLOSED");
                }
            }
            buffer.append("][");
            SSLIOSession.formatOps(buffer, this.appEventMask);
            buffer.append("][");
            buffer.append((Object)this.sslEngine.getHandshakeStatus());
            if (this.sslEngine.isInboundDone()) {
                buffer.append("][inbound done][");
            }
            if (this.sslEngine.isOutboundDone()) {
                buffer.append("][outbound done][");
            }
            if (this.endOfStream) {
                buffer.append("][EOF][");
            }
            buffer.append("][");
            buffer.append(!this.inEncrypted.hasData() ? 0 : this.inEncrypted.acquire().position());
            buffer.append("][");
            buffer.append(!this.inPlain.hasData() ? 0 : this.inPlain.acquire().position());
            buffer.append("][");
            buffer.append(!this.outEncrypted.hasData() ? 0 : this.outEncrypted.acquire().position());
            buffer.append("]");
            String string = buffer.toString();
            return string;
        }
        finally {
            this.session.getLock().unlock();
        }
    }
}

