/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution;

import java.util.Iterator;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.queue.BoundedInMemoryExecutor;
import org.apache.hudi.common.util.queue.BoundedInMemoryQueueProducer;
import org.apache.hudi.common.util.queue.IteratorBasedQueueProducer;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.execution.ExplicitWriteHandler;
import org.apache.hudi.execution.HoodieLazyInsertIterable;
import org.apache.hudi.io.ExplicitWriteHandleFactory;
import org.apache.hudi.io.HoodieWriteHandle;
import org.apache.hudi.io.WriteHandleFactory;
import org.apache.hudi.table.HoodieTable;

public class FlinkLazyInsertIterable<T extends HoodieRecordPayload>
extends HoodieLazyInsertIterable<T> {
    public FlinkLazyInsertIterable(Iterator<HoodieRecord<T>> recordItr, boolean areRecordsSorted, HoodieWriteConfig config, String instantTime, HoodieTable hoodieTable, String idPrefix, TaskContextSupplier taskContextSupplier, ExplicitWriteHandleFactory writeHandleFactory) {
        super(recordItr, areRecordsSorted, config, instantTime, hoodieTable, idPrefix, taskContextSupplier, (WriteHandleFactory)writeHandleFactory);
    }

    protected List<WriteStatus> computeNext() {
        BoundedInMemoryExecutor bufferedIteratorExecutor = null;
        try {
            Schema schema = new Schema.Parser().parse(this.hoodieConfig.getSchema());
            bufferedIteratorExecutor = new BoundedInMemoryExecutor((long)this.hoodieConfig.getWriteBufferLimitBytes(), (BoundedInMemoryQueueProducer)new IteratorBasedQueueProducer(this.inputItr), Option.of((Object)((Object)this.getExplicitInsertHandler())), FlinkLazyInsertIterable.getTransformFunction((Schema)schema, (HoodieWriteConfig)this.hoodieConfig));
            List result = (List)bufferedIteratorExecutor.execute();
            assert (result != null && !result.isEmpty() && !bufferedIteratorExecutor.isRemaining());
            List list = result;
            return list;
        }
        catch (Exception e) {
            throw new HoodieException((Throwable)e);
        }
        finally {
            if (null != bufferedIteratorExecutor) {
                bufferedIteratorExecutor.shutdownNow();
                bufferedIteratorExecutor.awaitTermination();
            }
        }
    }

    private ExplicitWriteHandler getExplicitInsertHandler() {
        HoodieWriteHandle handle = ((ExplicitWriteHandleFactory)this.writeHandleFactory).getWriteHandle();
        return new ExplicitWriteHandler(handle);
    }
}

