/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.index;

import java.util.Arrays;
import java.util.Map;
import org.apache.hudi.common.index.HoodieIndexType;

public class HoodieIndex {
    private String indexName;
    private String[] colNames;
    private HoodieIndexType indexType;
    private Map<String, Map<String, String>> colOptions;
    private Map<String, String> options;

    public HoodieIndex() {
    }

    public HoodieIndex(String indexName, String[] colNames, HoodieIndexType indexType, Map<String, Map<String, String>> colOptions, Map<String, String> options) {
        this.indexName = indexName;
        this.colNames = colNames;
        this.indexType = indexType;
        this.colOptions = colOptions;
        this.options = options;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String[] getColNames() {
        return this.colNames;
    }

    public HoodieIndexType getIndexType() {
        return this.indexType;
    }

    public Map<String, Map<String, String>> getColOptions() {
        return this.colOptions;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "HoodieIndex{indexName='" + this.indexName + '\'' + ", colNames='" + Arrays.toString(this.colNames) + '\'' + ", indexType=" + (Object)((Object)this.indexType) + ", colOptions=" + this.colOptions + ", options=" + this.options + '}';
    }

    public static class Builder {
        private String indexName;
        private String[] colNames;
        private HoodieIndexType indexType;
        private Map<String, Map<String, String>> colOptions;
        private Map<String, String> options;

        public Builder setIndexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public Builder setColNames(String[] colNames) {
            this.colNames = colNames;
            return this;
        }

        public Builder setIndexType(String indexType) {
            this.indexType = HoodieIndexType.of(indexType);
            return this;
        }

        public Builder setColOptions(Map<String, Map<String, String>> colOptions) {
            this.colOptions = colOptions;
            return this;
        }

        public Builder setOptions(Map<String, String> options) {
            this.options = options;
            return this;
        }

        public HoodieIndex build() {
            return new HoodieIndex(this.indexName, this.colNames, this.indexType, this.colOptions, this.options);
        }
    }
}

