/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.Serializable;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.util.Option;

public class FileSlice
implements Serializable {
    private final HoodieFileGroupId fileGroupId;
    private final String baseInstantTime;
    private HoodieBaseFile baseFile;
    private final TreeSet<HoodieLogFile> logFiles;

    public FileSlice(FileSlice fileSlice) {
        this.baseInstantTime = fileSlice.baseInstantTime;
        this.baseFile = fileSlice.baseFile != null ? new HoodieBaseFile(fileSlice.baseFile) : null;
        this.fileGroupId = fileSlice.fileGroupId;
        this.logFiles = new TreeSet<HoodieLogFile>(HoodieLogFile.getReverseLogFileComparator());
        fileSlice.logFiles.forEach(lf -> this.logFiles.add(new HoodieLogFile((HoodieLogFile)lf)));
    }

    public FileSlice(String partitionPath, String baseInstantTime, String fileId) {
        this(new HoodieFileGroupId(partitionPath, fileId), baseInstantTime);
    }

    public FileSlice(HoodieFileGroupId fileGroupId, String baseInstantTime) {
        this.fileGroupId = fileGroupId;
        this.baseInstantTime = baseInstantTime;
        this.baseFile = null;
        this.logFiles = new TreeSet<HoodieLogFile>(HoodieLogFile.getReverseLogFileComparator());
    }

    public void setBaseFile(HoodieBaseFile baseFile) {
        this.baseFile = baseFile;
    }

    public void addLogFile(HoodieLogFile logFile) {
        this.logFiles.add(logFile);
    }

    public Stream<HoodieLogFile> getLogFiles() {
        return this.logFiles.stream();
    }

    public String getBaseInstantTime() {
        return this.baseInstantTime;
    }

    public String getPartitionPath() {
        return this.fileGroupId.getPartitionPath();
    }

    public String getFileId() {
        return this.fileGroupId.getFileId();
    }

    public HoodieFileGroupId getFileGroupId() {
        return this.fileGroupId;
    }

    public Option<HoodieBaseFile> getBaseFile() {
        return Option.ofNullable(this.baseFile);
    }

    public Option<HoodieLogFile> getLatestLogFile() {
        return Option.fromJavaOptional(this.logFiles.stream().findFirst());
    }

    public boolean isEmpty() {
        return this.baseFile == null && this.logFiles.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FileSlice {");
        sb.append("fileGroupId=").append(this.fileGroupId);
        sb.append(", baseCommitTime=").append(this.baseInstantTime);
        sb.append(", baseFile='").append(this.baseFile).append('\'');
        sb.append(", logFiles='").append(this.logFiles).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSlice slice = (FileSlice)o;
        return Objects.equals(this.fileGroupId, slice.fileGroupId) && Objects.equals(this.baseInstantTime, slice.baseInstantTime) && Objects.equals(this.baseFile, slice.baseFile) && Objects.equals(this.logFiles, slice.logFiles);
    }

    public int hashCode() {
        return Objects.hash(this.fileGroupId, this.baseInstantTime);
    }
}

