/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model.debezium;

import java.io.IOException;
import org.apache.hudi.common.model.debezium.AbstractDebeziumAvroPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.GenericRecord;
import org.apache.hudi.org.apache.avro.generic.IndexedRecord;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class MySqlDebeziumAvroPayload
extends AbstractDebeziumAvroPayload {
    private static final Logger LOG = LogManager.getLogger(MySqlDebeziumAvroPayload.class);

    public MySqlDebeziumAvroPayload(GenericRecord record, Comparable orderingVal) {
        super(record, orderingVal);
    }

    public MySqlDebeziumAvroPayload(Option<GenericRecord> record) {
        super(record);
    }

    private String extractSeq(IndexedRecord record) {
        return ((CharSequence)((GenericRecord)record).get("_event_seq")).toString();
    }

    @Override
    protected boolean shouldPickCurrentRecord(IndexedRecord currentRecord, IndexedRecord insertRecord, Schema schema) throws IOException {
        String currentSourceSeq = this.extractSeq(currentRecord);
        String insertSourceSeq = this.extractSeq(insertRecord);
        return insertSourceSeq.compareTo(currentSourceSeq) < 0;
    }
}

