/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.errorhandling;

import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class TimeoutException
extends Exception {
    private final String sourceName;
    private final long start;
    private final long end;
    private final long expected;

    public TimeoutException(String sourceName, long start, long end, long expected) {
        super("Timeout elapsed! Source:" + sourceName + " Start:" + start + ", End:" + end + ", diff:" + (end - start) + ", max:" + expected + " ms");
        this.sourceName = sourceName;
        this.start = start;
        this.end = end;
        this.expected = expected;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public long getMaxAllowedOperationTime() {
        return this.expected;
    }

    public String getSourceName() {
        return this.sourceName;
    }
}

