/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver;

import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.MemStoreCompactionStrategy;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.Segment;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.VersionedSegmentsList;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class AdaptiveMemStoreCompactionStrategy
extends MemStoreCompactionStrategy {
    private static final String NAME = "ADAPTIVE";
    public static final String ADAPTIVE_COMPACTION_THRESHOLD_KEY = "hbase.hregion.compacting.memstore.adaptive.compaction.threshold";
    private static final double ADAPTIVE_COMPACTION_THRESHOLD_DEFAULT = 0.5;
    public static final String ADAPTIVE_INITIAL_COMPACTION_PROBABILITY_KEY = "hbase.hregion.compacting.memstore.adaptive.compaction.probability";
    private static final double ADAPTIVE_INITIAL_COMPACTION_PROBABILITY_DEFAULT = 0.5;
    private static final double ADAPTIVE_PROBABILITY_FACTOR = 1.02;
    private double compactionThreshold;
    private double initialCompactionProbability;
    private double compactionProbability;
    private Random rand = new Random();
    private double numCellsInVersionedList = 0.0;
    private boolean compacted = false;

    public AdaptiveMemStoreCompactionStrategy(Configuration conf, String cfName) {
        super(conf, cfName);
        this.compactionThreshold = conf.getDouble(ADAPTIVE_COMPACTION_THRESHOLD_KEY, 0.5);
        this.initialCompactionProbability = conf.getDouble(ADAPTIVE_INITIAL_COMPACTION_PROBABILITY_KEY, 0.5);
        this.resetStats();
    }

    @Override
    public MemStoreCompactionStrategy.Action getAction(VersionedSegmentsList versionedList) {
        double r;
        if (versionedList.getEstimatedUniquesFrac() < 1.0 - this.compactionThreshold && (r = this.rand.nextDouble()) < this.compactionProbability) {
            this.numCellsInVersionedList = versionedList.getNumOfCells();
            this.compacted = true;
            return this.compact(versionedList, this.getName() + " (compaction probability=" + this.compactionProbability + ")");
        }
        this.compacted = false;
        return this.simpleMergeOrFlatten(versionedList, this.getName() + " (compaction probability=" + this.compactionProbability + ")");
    }

    @Override
    public void updateStats(Segment replacement) {
        if (this.compacted) {
            if ((double)replacement.getCellsCount() / this.numCellsInVersionedList < 1.0 - this.compactionThreshold) {
                this.compactionProbability *= 1.02;
                if (this.compactionProbability > 1.0) {
                    this.compactionProbability = 1.0;
                }
            } else {
                this.compactionProbability /= 1.02;
            }
        }
    }

    @Override
    public void resetStats() {
        this.compactionProbability = this.initialCompactionProbability;
    }

    @Override
    protected MemStoreCompactionStrategy.Action getMergingAction() {
        return MemStoreCompactionStrategy.Action.MERGE_COUNT_UNIQUE_KEYS;
    }

    @Override
    protected MemStoreCompactionStrategy.Action getFlattenAction() {
        return MemStoreCompactionStrategy.Action.FLATTEN;
    }

    @Override
    protected String getName() {
        return NAME;
    }
}

