/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.CellComparator;
import org.apache.hudi.org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hudi.org.apache.hadoop.hbase.KeyValue;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.AbstractMemStore;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.ImmutableSegment;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.MemStoreSize;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.MemStoreSizing;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.MemStoreSnapshot;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.MutableSegment;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.NonThreadSafeMemStoreSizing;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.RegionServicesForStores;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.Segment;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.SegmentFactory;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hudi.org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DefaultMemStore
extends AbstractMemStore {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMemStore.class);
    public static final long DEEP_OVERHEAD = ClassSize.align(AbstractMemStore.DEEP_OVERHEAD);
    public static final long FIXED_OVERHEAD = ClassSize.align(AbstractMemStore.FIXED_OVERHEAD);

    public DefaultMemStore() {
        this(HBaseConfiguration.create(), CellComparator.getInstance(), null);
    }

    public DefaultMemStore(Configuration conf, CellComparator c) {
        super(conf, c, null);
    }

    public DefaultMemStore(Configuration conf, CellComparator c, RegionServicesForStores regionServices) {
        super(conf, c, regionServices);
    }

    @Override
    public MemStoreSnapshot snapshot() {
        if (!this.snapshot.isEmpty()) {
            LOG.warn("Snapshot called again without clearing previous. Doing nothing. Another ongoing flush or did we fail last attempt?");
        } else {
            this.snapshotId = EnvironmentEdgeManager.currentTime();
            if (!this.getActive().isEmpty()) {
                NonThreadSafeMemStoreSizing memstoreAccounting = new NonThreadSafeMemStoreSizing();
                ImmutableSegment immutableSegment = SegmentFactory.instance().createImmutableSegment(this.getActive(), memstoreAccounting);
                if (this.regionServices != null) {
                    this.regionServices.addMemStoreSize(memstoreAccounting.getDataSize(), memstoreAccounting.getHeapSize(), memstoreAccounting.getOffHeapSize(), memstoreAccounting.getCellsCount());
                }
                this.snapshot = immutableSegment;
                this.resetActive();
                this.resetTimeOfOldestEdit();
            }
        }
        return new MemStoreSnapshot(this.snapshotId, this.snapshot);
    }

    @Override
    public MemStoreSize getFlushableSize() {
        MemStoreSize mss = this.getSnapshotSize();
        return mss.getDataSize() > 0L ? mss : this.getActive().getMemStoreSize();
    }

    @Override
    protected long keySize() {
        return this.getActive().getDataSize();
    }

    @Override
    protected long heapSize() {
        return this.getActive().getHeapSize();
    }

    @Override
    public List<KeyValueScanner> getScanners(long readPt) throws IOException {
        ArrayList<KeyValueScanner> list = new ArrayList<KeyValueScanner>();
        DefaultMemStore.addToScanners(this.getActive(), readPt, list);
        DefaultMemStore.addToScanners(this.getSnapshotSegments(), readPt, list);
        return list;
    }

    protected List<Segment> getSnapshotSegments() {
        return this.snapshot.getAllSegments();
    }

    @Override
    protected List<Segment> getSegments() throws IOException {
        ArrayList<Segment> list = new ArrayList<Segment>(2);
        list.add(this.getActive());
        list.add(this.snapshot);
        return list;
    }

    Cell getNextRow(Cell cell) {
        return this.getLowest(this.getNextRow(cell, this.getActive().getCellSet()), this.getNextRow(cell, this.snapshot.getCellSet()));
    }

    @Override
    public void updateLowestUnflushedSequenceIdInWAL(boolean onlyIfMoreRecent) {
    }

    @Override
    protected boolean preUpdate(MutableSegment currentActive, Cell cell, MemStoreSizing memstoreSizing) {
        return true;
    }

    @Override
    protected void postUpdate(MutableSegment currentActive) {
    }

    @Override
    protected boolean sizeAddedPreOperation() {
        return false;
    }

    @Override
    public MemStoreSize size() {
        return this.getActive().getMemStoreSize();
    }

    @Override
    public long preFlushSeqIDEstimation() {
        return -1L;
    }

    @Override
    public boolean isSloppy() {
        return false;
    }

    public static void main(String[] args) {
        int i;
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        LOG.info("vmName=" + runtime.getVmName() + ", vmVendor=" + runtime.getVmVendor() + ", vmVersion=" + runtime.getVmVersion());
        LOG.info("vmInputArguments=" + runtime.getInputArguments());
        DefaultMemStore memstore1 = new DefaultMemStore();
        int count = 10000;
        byte[] fam = Bytes.toBytes("col");
        byte[] qf = Bytes.toBytes("umn");
        byte[] empty = new byte[]{};
        NonThreadSafeMemStoreSizing memStoreSizing = new NonThreadSafeMemStoreSizing();
        for (i = 0; i < 10000; ++i) {
            memstore1.add(new KeyValue(Bytes.toBytes(i), fam, qf, (long)i, empty), (MemStoreSizing)memStoreSizing);
        }
        LOG.info("memstore1 estimated size={}", (Object)(memStoreSizing.getMemStoreSize().getDataSize() + memStoreSizing.getMemStoreSize().getHeapSize()));
        for (i = 0; i < 10000; ++i) {
            memstore1.add(new KeyValue(Bytes.toBytes(i), fam, qf, (long)i, empty), (MemStoreSizing)memStoreSizing);
        }
        LOG.info("memstore1 estimated size (2nd loading of same data)={}", (Object)(memStoreSizing.getMemStoreSize().getDataSize() + memStoreSizing.getMemStoreSize().getHeapSize()));
        DefaultMemStore memstore2 = new DefaultMemStore();
        memStoreSizing = new NonThreadSafeMemStoreSizing();
        for (int i2 = 0; i2 < 10000; ++i2) {
            memstore2.add(new KeyValue(Bytes.toBytes(i2), fam, qf, (long)i2, new byte[i2]), (MemStoreSizing)memStoreSizing);
        }
        LOG.info("memstore2 estimated size={}", (Object)(memStoreSizing.getMemStoreSize().getDataSize() + memStoreSizing.getMemStoreSize().getHeapSize()));
        int seconds = 30;
        LOG.info("Waiting 30 seconds while heap dump is taken");
        LOG.info("Exiting.");
    }
}

