/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.replication.regionserver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.org.apache.hadoop.hbase.util.Pair;
import org.apache.hudi.org.apache.hadoop.hbase.wal.WAL;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class WALEntryBatch {
    public static final WALEntryBatch NO_MORE_DATA = new WALEntryBatch(0, null);
    private List<Pair<WAL.Entry, Long>> walEntriesWithSize;
    private Path lastWalPath;
    private long lastWalPosition = 0L;
    private int nbRowKeys = 0;
    private int nbHFiles = 0;
    private long heapSize = 0L;
    private Map<String, Long> lastSeqIds = new HashMap<String, Long>();
    private boolean endOfFile;

    WALEntryBatch(int maxNbEntries, Path lastWalPath) {
        this.walEntriesWithSize = new ArrayList<Pair<WAL.Entry, Long>>(maxNbEntries);
        this.lastWalPath = lastWalPath;
    }

    static WALEntryBatch endOfFile(Path lastWalPath) {
        WALEntryBatch batch = new WALEntryBatch(0, lastWalPath);
        batch.setLastWalPosition(-1L);
        batch.setEndOfFile(true);
        return batch;
    }

    public void addEntry(WAL.Entry entry, long entrySize) {
        this.walEntriesWithSize.add(new Pair<WAL.Entry, Long>(entry, entrySize));
    }

    public List<WAL.Entry> getWalEntries() {
        return this.walEntriesWithSize.stream().map(Pair::getFirst).collect(Collectors.toList());
    }

    public List<Pair<WAL.Entry, Long>> getWalEntriesWithSize() {
        return this.walEntriesWithSize;
    }

    public Path getLastWalPath() {
        return this.lastWalPath;
    }

    public void setLastWalPath(Path lastWalPath) {
        this.lastWalPath = lastWalPath;
    }

    public long getLastWalPosition() {
        return this.lastWalPosition;
    }

    public void setLastWalPosition(long lastWalPosition) {
        this.lastWalPosition = lastWalPosition;
    }

    public int getNbEntries() {
        return this.walEntriesWithSize.size();
    }

    public int getNbRowKeys() {
        return this.nbRowKeys;
    }

    public int getNbHFiles() {
        return this.nbHFiles;
    }

    public int getNbOperations() {
        return this.getNbRowKeys() + this.getNbHFiles();
    }

    public long getHeapSize() {
        return this.heapSize;
    }

    public Map<String, Long> getLastSeqIds() {
        return this.lastSeqIds;
    }

    public boolean isEndOfFile() {
        return this.endOfFile;
    }

    public void setEndOfFile(boolean endOfFile) {
        this.endOfFile = endOfFile;
    }

    public void incrementNbRowKeys(int increment) {
        this.nbRowKeys += increment;
    }

    public void incrementNbHFiles(int increment) {
        this.nbHFiles += increment;
    }

    public void incrementHeapSize(long increment) {
        this.heapSize += increment;
    }

    public void setLastSeqId(String region, long sequenceId) {
        this.lastSeqIds.put(region, sequenceId);
    }

    public String toString() {
        return "WALEntryBatch [walEntries=" + this.walEntriesWithSize + ", lastWalPath=" + this.lastWalPath + ", lastWalPosition=" + this.lastWalPosition + ", nbRowKeys=" + this.nbRowKeys + ", nbHFiles=" + this.nbHFiles + ", heapSize=" + this.heapSize + ", lastSeqIds=" + this.lastSeqIds + ", endOfFile=" + this.endOfFile + "]";
    }
}

