/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.parquet.schema;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.hudi.org.apache.parquet.Preconditions;
import org.apache.hudi.org.apache.parquet.ShouldNeverHappenException;
import org.apache.hudi.org.apache.parquet.column.ColumnReader;
import org.apache.hudi.org.apache.parquet.io.InvalidRecordException;
import org.apache.hudi.org.apache.parquet.io.api.Binary;
import org.apache.hudi.org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.hudi.org.apache.parquet.io.api.RecordConsumer;
import org.apache.hudi.org.apache.parquet.schema.ColumnOrder;
import org.apache.hudi.org.apache.parquet.schema.DecimalMetadata;
import org.apache.hudi.org.apache.parquet.schema.GroupType;
import org.apache.hudi.org.apache.parquet.schema.IncompatibleSchemaModificationException;
import org.apache.hudi.org.apache.parquet.schema.OriginalType;
import org.apache.hudi.org.apache.parquet.schema.PrimitiveComparator;
import org.apache.hudi.org.apache.parquet.schema.PrimitiveStringifier;
import org.apache.hudi.org.apache.parquet.schema.Type;
import org.apache.hudi.org.apache.parquet.schema.TypeConverter;
import org.apache.hudi.org.apache.parquet.schema.TypeVisitor;
import org.apache.hudi.org.apache.parquet.schema.Types;

public final class PrimitiveType
extends Type {
    private final PrimitiveTypeName primitive;
    private final int length;
    private final DecimalMetadata decimalMeta;
    private final ColumnOrder columnOrder;

    public PrimitiveType(Type.Repetition repetition, PrimitiveTypeName primitive, String name) {
        this(repetition, primitive, 0, name, null, null, null);
    }

    public PrimitiveType(Type.Repetition repetition, PrimitiveTypeName primitive, int length, String name) {
        this(repetition, primitive, length, name, null, null, null);
    }

    public PrimitiveType(Type.Repetition repetition, PrimitiveTypeName primitive, String name, OriginalType originalType) {
        this(repetition, primitive, 0, name, originalType, null, null);
    }

    @Deprecated
    public PrimitiveType(Type.Repetition repetition, PrimitiveTypeName primitive, int length, String name, OriginalType originalType) {
        this(repetition, primitive, length, name, originalType, null, null);
    }

    public PrimitiveType(Type.Repetition repetition, PrimitiveTypeName primitive, int length, String name, OriginalType originalType, DecimalMetadata decimalMeta, Type.ID id) {
        this(repetition, primitive, length, name, originalType, decimalMeta, id, null);
    }

    PrimitiveType(Type.Repetition repetition, PrimitiveTypeName primitive, int length, String name, OriginalType originalType, DecimalMetadata decimalMeta, Type.ID id, ColumnOrder columnOrder) {
        super(name, repetition, originalType, id);
        this.primitive = primitive;
        this.length = length;
        this.decimalMeta = decimalMeta;
        if (columnOrder == null) {
            columnOrder = primitive == PrimitiveTypeName.INT96 || originalType == OriginalType.INTERVAL ? ColumnOrder.undefined() : ColumnOrder.typeDefined();
        }
        this.columnOrder = this.requireValidColumnOrder(columnOrder);
    }

    private ColumnOrder requireValidColumnOrder(ColumnOrder columnOrder) {
        if (this.primitive == PrimitiveTypeName.INT96) {
            Preconditions.checkArgument(columnOrder.getColumnOrderName() == ColumnOrder.ColumnOrderName.UNDEFINED, "The column order {} is not supported by INT96", columnOrder);
        }
        if (this.getOriginalType() != null) {
            switch (this.getOriginalType()) {
                case UINT_64: 
                case INT_64: 
                case DECIMAL: 
                case TIME_MICROS: 
                case TIMESTAMP_MILLIS: 
                case TIMESTAMP_MICROS: 
                case UINT_8: 
                case UINT_16: 
                case UINT_32: 
                case INT_8: 
                case INT_16: 
                case INT_32: 
                case DATE: 
                case TIME_MILLIS: 
                case UTF8: 
                case ENUM: 
                case JSON: 
                case BSON: {
                    break;
                }
                default: {
                    Preconditions.checkArgument(columnOrder.getColumnOrderName() == ColumnOrder.ColumnOrderName.UNDEFINED, "The column order {} is not supported by {} ({})", new Object[]{columnOrder, this.primitive, this.getOriginalType()});
                }
            }
        }
        return columnOrder;
    }

    @Override
    public PrimitiveType withId(int id) {
        return new PrimitiveType(this.getRepetition(), this.primitive, this.length, this.getName(), this.getOriginalType(), this.decimalMeta, new Type.ID(id), this.columnOrder);
    }

    public PrimitiveTypeName getPrimitiveTypeName() {
        return this.primitive;
    }

    public int getTypeLength() {
        return this.length;
    }

    public DecimalMetadata getDecimalMetadata() {
        return this.decimalMeta;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void writeToStringBuilder(StringBuilder sb, String indent) {
        sb.append(indent).append(this.getRepetition().name().toLowerCase(Locale.ENGLISH)).append(" ").append(this.primitive.name().toLowerCase());
        if (this.primitive == PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY) {
            sb.append("(" + this.length + ")");
        }
        sb.append(" ").append(this.getName());
        if (this.getOriginalType() != null) {
            sb.append(" (").append((Object)this.getOriginalType());
            DecimalMetadata meta = this.getDecimalMetadata();
            if (meta != null) {
                sb.append("(").append(meta.getPrecision()).append(",").append(meta.getScale()).append(")");
            }
            sb.append(")");
        }
        if (this.getId() != null) {
            sb.append(" = ").append(this.getId());
        }
    }

    @Override
    @Deprecated
    protected int typeHashCode() {
        return this.hashCode();
    }

    @Override
    @Deprecated
    protected boolean typeEquals(Type other) {
        return this.equals(other);
    }

    @Override
    protected boolean equals(Type other) {
        if (!other.isPrimitive()) {
            return false;
        }
        PrimitiveType otherPrimitive = other.asPrimitiveType();
        return super.equals(other) && this.primitive == otherPrimitive.getPrimitiveTypeName() && this.length == otherPrimitive.length && this.columnOrder.equals(otherPrimitive.columnOrder) && this.eqOrBothNull(this.decimalMeta, otherPrimitive.decimalMeta);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = hash * 31 + this.primitive.hashCode();
        hash = hash * 31 + this.length;
        hash = hash * 31 + this.columnOrder.hashCode();
        if (this.decimalMeta != null) {
            hash = hash * 31 + this.decimalMeta.hashCode();
        }
        return hash;
    }

    @Override
    public int getMaxRepetitionLevel(String[] path, int i) {
        if (path.length != i) {
            throw new InvalidRecordException("Arrived at primitive node, path invalid");
        }
        return this.isRepetition(Type.Repetition.REPEATED) ? 1 : 0;
    }

    @Override
    public int getMaxDefinitionLevel(String[] path, int i) {
        if (path.length != i) {
            throw new InvalidRecordException("Arrived at primitive node, path invalid");
        }
        return this.isRepetition(Type.Repetition.REQUIRED) ? 0 : 1;
    }

    @Override
    public Type getType(String[] path, int i) {
        if (path.length != i) {
            throw new InvalidRecordException("Arrived at primitive node at index " + i + " , path invalid: " + Arrays.toString(path));
        }
        return this;
    }

    @Override
    protected List<String[]> getPaths(int depth) {
        return Arrays.asList(new String[][]{new String[depth]});
    }

    @Override
    void checkContains(Type subType) {
        super.checkContains(subType);
        if (!subType.isPrimitive()) {
            throw new InvalidRecordException(subType + " found: expected " + this);
        }
        PrimitiveType primitiveType = subType.asPrimitiveType();
        if (this.primitive != primitiveType.primitive) {
            throw new InvalidRecordException(subType + " found: expected " + this);
        }
    }

    @Override
    public <T> T convert(List<GroupType> path, TypeConverter<T> converter) {
        return converter.convertPrimitiveType(path, this);
    }

    @Override
    protected boolean containsPath(String[] path, int depth) {
        return path.length == depth;
    }

    @Override
    protected Type union(Type toMerge) {
        return this.union(toMerge, true);
    }

    private void reportSchemaMergeError(Type toMerge) {
        throw new IncompatibleSchemaModificationException("can not merge type " + toMerge + " into " + this);
    }

    private void reportSchemaMergeErrorWithColumnOrder(Type toMerge) {
        throw new IncompatibleSchemaModificationException("can not merge type " + toMerge + " with column order " + toMerge.asPrimitiveType().columnOrder() + " into " + this + " with column order " + this.columnOrder());
    }

    @Override
    protected Type union(Type toMerge, boolean strict) {
        if (!toMerge.isPrimitive()) {
            this.reportSchemaMergeError(toMerge);
        }
        if (strict) {
            if (!this.primitive.equals((Object)toMerge.asPrimitiveType().getPrimitiveTypeName()) || this.getOriginalType() != toMerge.getOriginalType()) {
                this.reportSchemaMergeError(toMerge);
            }
            int toMergeLength = toMerge.asPrimitiveType().getTypeLength();
            if (this.primitive == PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY && this.length != toMergeLength) {
                this.reportSchemaMergeError(toMerge);
            }
            if (!this.columnOrder().equals(toMerge.asPrimitiveType().columnOrder())) {
                this.reportSchemaMergeErrorWithColumnOrder(toMerge);
            }
        }
        Types.PrimitiveBuilder<PrimitiveType> builder = Types.primitive(this.primitive, toMerge.getRepetition());
        if (PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY == this.primitive) {
            builder.length(this.length);
        }
        return (Type)((Types.PrimitiveBuilder)builder.as(this.getOriginalType())).named(this.getName());
    }

    public <T> PrimitiveComparator<T> comparator() {
        return this.getPrimitiveTypeName().comparator(this.getOriginalType());
    }

    public ColumnOrder columnOrder() {
        return this.columnOrder;
    }

    public PrimitiveStringifier stringifier() {
        OriginalType originalType = this.getOriginalType();
        return originalType == null ? PrimitiveStringifier.DEFAULT_STRINGIFIER : originalType.stringifier(this);
    }

    public static enum PrimitiveTypeName {
        INT64("getLong", (Class)Long.TYPE){

            @Override
            public String toString(ColumnReader columnReader) {
                return String.valueOf(columnReader.getLong());
            }

            @Override
            public void addValueToRecordConsumer(RecordConsumer recordConsumer, ColumnReader columnReader) {
                recordConsumer.addLong(columnReader.getLong());
            }

            @Override
            public void addValueToPrimitiveConverter(PrimitiveConverter primitiveConverter, ColumnReader columnReader) {
                primitiveConverter.addLong(columnReader.getLong());
            }

            @Override
            public <T, E extends Exception> T convert(PrimitiveTypeNameConverter<T, E> converter) throws E {
                return converter.convertINT64(this);
            }

            @Override
            PrimitiveComparator<?> comparator(OriginalType logicalType) {
                if (logicalType == null) {
                    return PrimitiveComparator.SIGNED_INT64_COMPARATOR;
                }
                switch (logicalType) {
                    case UINT_64: {
                        return PrimitiveComparator.UNSIGNED_INT64_COMPARATOR;
                    }
                    case INT_64: 
                    case DECIMAL: 
                    case TIME_MICROS: 
                    case TIMESTAMP_MILLIS: 
                    case TIMESTAMP_MICROS: {
                        return PrimitiveComparator.SIGNED_INT64_COMPARATOR;
                    }
                }
                throw new ShouldNeverHappenException("No comparator logic implemented for INT64 logical type: " + (Object)((Object)logicalType));
            }
        }
        ,
        INT32("getInteger", (Class)Integer.TYPE){

            @Override
            public String toString(ColumnReader columnReader) {
                return String.valueOf(columnReader.getInteger());
            }

            @Override
            public void addValueToRecordConsumer(RecordConsumer recordConsumer, ColumnReader columnReader) {
                recordConsumer.addInteger(columnReader.getInteger());
            }

            @Override
            public void addValueToPrimitiveConverter(PrimitiveConverter primitiveConverter, ColumnReader columnReader) {
                primitiveConverter.addInt(columnReader.getInteger());
            }

            @Override
            public <T, E extends Exception> T convert(PrimitiveTypeNameConverter<T, E> converter) throws E {
                return converter.convertINT32(this);
            }

            @Override
            PrimitiveComparator<?> comparator(OriginalType logicalType) {
                if (logicalType == null) {
                    return PrimitiveComparator.SIGNED_INT32_COMPARATOR;
                }
                switch (logicalType) {
                    case UINT_8: 
                    case UINT_16: 
                    case UINT_32: {
                        return PrimitiveComparator.UNSIGNED_INT32_COMPARATOR;
                    }
                    case DECIMAL: 
                    case INT_8: 
                    case INT_16: 
                    case INT_32: 
                    case DATE: 
                    case TIME_MILLIS: {
                        return PrimitiveComparator.SIGNED_INT32_COMPARATOR;
                    }
                }
                throw new ShouldNeverHappenException("No comparator logic implemented for INT32 logical type: " + (Object)((Object)logicalType));
            }
        }
        ,
        BOOLEAN("getBoolean", (Class)Boolean.TYPE){

            @Override
            public String toString(ColumnReader columnReader) {
                return String.valueOf(columnReader.getBoolean());
            }

            @Override
            public void addValueToRecordConsumer(RecordConsumer recordConsumer, ColumnReader columnReader) {
                recordConsumer.addBoolean(columnReader.getBoolean());
            }

            @Override
            public void addValueToPrimitiveConverter(PrimitiveConverter primitiveConverter, ColumnReader columnReader) {
                primitiveConverter.addBoolean(columnReader.getBoolean());
            }

            @Override
            public <T, E extends Exception> T convert(PrimitiveTypeNameConverter<T, E> converter) throws E {
                return converter.convertBOOLEAN(this);
            }

            @Override
            PrimitiveComparator<?> comparator(OriginalType logicalType) {
                return PrimitiveComparator.BOOLEAN_COMPARATOR;
            }
        }
        ,
        BINARY("getBinary", (Class)Binary.class){

            @Override
            public String toString(ColumnReader columnReader) {
                return String.valueOf(columnReader.getBinary());
            }

            @Override
            public void addValueToRecordConsumer(RecordConsumer recordConsumer, ColumnReader columnReader) {
                recordConsumer.addBinary(columnReader.getBinary());
            }

            @Override
            public void addValueToPrimitiveConverter(PrimitiveConverter primitiveConverter, ColumnReader columnReader) {
                primitiveConverter.addBinary(columnReader.getBinary());
            }

            @Override
            public <T, E extends Exception> T convert(PrimitiveTypeNameConverter<T, E> converter) throws E {
                return converter.convertBINARY(this);
            }

            @Override
            PrimitiveComparator<?> comparator(OriginalType logicalType) {
                if (logicalType == null) {
                    return PrimitiveComparator.UNSIGNED_LEXICOGRAPHICAL_BINARY_COMPARATOR;
                }
                switch (logicalType) {
                    case DECIMAL: {
                        return PrimitiveComparator.BINARY_AS_SIGNED_INTEGER_COMPARATOR;
                    }
                    case UTF8: 
                    case ENUM: 
                    case JSON: 
                    case BSON: {
                        return PrimitiveComparator.UNSIGNED_LEXICOGRAPHICAL_BINARY_COMPARATOR;
                    }
                }
                throw new ShouldNeverHappenException("No comparator logic implemented for BINARY logical type: " + (Object)((Object)logicalType));
            }
        }
        ,
        FLOAT("getFloat", (Class)Float.TYPE){

            @Override
            public String toString(ColumnReader columnReader) {
                return String.valueOf(columnReader.getFloat());
            }

            @Override
            public void addValueToRecordConsumer(RecordConsumer recordConsumer, ColumnReader columnReader) {
                recordConsumer.addFloat(columnReader.getFloat());
            }

            @Override
            public void addValueToPrimitiveConverter(PrimitiveConverter primitiveConverter, ColumnReader columnReader) {
                primitiveConverter.addFloat(columnReader.getFloat());
            }

            @Override
            public <T, E extends Exception> T convert(PrimitiveTypeNameConverter<T, E> converter) throws E {
                return converter.convertFLOAT(this);
            }

            @Override
            PrimitiveComparator<?> comparator(OriginalType logicalType) {
                return PrimitiveComparator.FLOAT_COMPARATOR;
            }
        }
        ,
        DOUBLE("getDouble", (Class)Double.TYPE){

            @Override
            public String toString(ColumnReader columnReader) {
                return String.valueOf(columnReader.getDouble());
            }

            @Override
            public void addValueToRecordConsumer(RecordConsumer recordConsumer, ColumnReader columnReader) {
                recordConsumer.addDouble(columnReader.getDouble());
            }

            @Override
            public void addValueToPrimitiveConverter(PrimitiveConverter primitiveConverter, ColumnReader columnReader) {
                primitiveConverter.addDouble(columnReader.getDouble());
            }

            @Override
            public <T, E extends Exception> T convert(PrimitiveTypeNameConverter<T, E> converter) throws E {
                return converter.convertDOUBLE(this);
            }

            @Override
            PrimitiveComparator<?> comparator(OriginalType logicalType) {
                return PrimitiveComparator.DOUBLE_COMPARATOR;
            }
        }
        ,
        INT96("getBinary", (Class)Binary.class){

            @Override
            public String toString(ColumnReader columnReader) {
                return Arrays.toString(columnReader.getBinary().getBytesUnsafe());
            }

            @Override
            public void addValueToRecordConsumer(RecordConsumer recordConsumer, ColumnReader columnReader) {
                recordConsumer.addBinary(columnReader.getBinary());
            }

            @Override
            public void addValueToPrimitiveConverter(PrimitiveConverter primitiveConverter, ColumnReader columnReader) {
                primitiveConverter.addBinary(columnReader.getBinary());
            }

            @Override
            public <T, E extends Exception> T convert(PrimitiveTypeNameConverter<T, E> converter) throws E {
                return converter.convertINT96(this);
            }

            @Override
            PrimitiveComparator<?> comparator(OriginalType logicalType) {
                return PrimitiveComparator.BINARY_AS_SIGNED_INTEGER_COMPARATOR;
            }
        }
        ,
        FIXED_LEN_BYTE_ARRAY("getBinary", (Class)Binary.class){

            @Override
            public String toString(ColumnReader columnReader) {
                return String.valueOf(columnReader.getBinary());
            }

            @Override
            public void addValueToRecordConsumer(RecordConsumer recordConsumer, ColumnReader columnReader) {
                recordConsumer.addBinary(columnReader.getBinary());
            }

            @Override
            public void addValueToPrimitiveConverter(PrimitiveConverter primitiveConverter, ColumnReader columnReader) {
                primitiveConverter.addBinary(columnReader.getBinary());
            }

            @Override
            public <T, E extends Exception> T convert(PrimitiveTypeNameConverter<T, E> converter) throws E {
                return converter.convertFIXED_LEN_BYTE_ARRAY(this);
            }

            @Override
            PrimitiveComparator<?> comparator(OriginalType logicalType) {
                if (logicalType == null) {
                    return PrimitiveComparator.UNSIGNED_LEXICOGRAPHICAL_BINARY_COMPARATOR;
                }
                switch (logicalType) {
                    case DECIMAL: {
                        return PrimitiveComparator.BINARY_AS_SIGNED_INTEGER_COMPARATOR;
                    }
                    case INTERVAL: {
                        return PrimitiveComparator.UNSIGNED_LEXICOGRAPHICAL_BINARY_COMPARATOR;
                    }
                }
                throw new ShouldNeverHappenException("No comparator logic implemented for FIXED_LEN_BYTE_ARRAY logical type: " + (Object)((Object)logicalType));
            }
        };

        public final String getMethod;
        public final Class<?> javaType;

        private PrimitiveTypeName(String getMethod, Class<?> javaType) {
            this.getMethod = getMethod;
            this.javaType = javaType;
        }

        public abstract String toString(ColumnReader var1);

        public abstract void addValueToRecordConsumer(RecordConsumer var1, ColumnReader var2);

        public abstract void addValueToPrimitiveConverter(PrimitiveConverter var1, ColumnReader var2);

        public abstract <T, E extends Exception> T convert(PrimitiveTypeNameConverter<T, E> var1) throws E;

        abstract PrimitiveComparator<?> comparator(OriginalType var1);
    }

    public static interface PrimitiveTypeNameConverter<T, E extends Exception> {
        public T convertFLOAT(PrimitiveTypeName var1) throws E;

        public T convertDOUBLE(PrimitiveTypeName var1) throws E;

        public T convertINT32(PrimitiveTypeName var1) throws E;

        public T convertINT64(PrimitiveTypeName var1) throws E;

        public T convertINT96(PrimitiveTypeName var1) throws E;

        public T convertFIXED_LEN_BYTE_ARRAY(PrimitiveTypeName var1) throws E;

        public T convertBOOLEAN(PrimitiveTypeName var1) throws E;

        public T convertBINARY(PrimitiveTypeName var1) throws E;
    }
}

