/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.shaded.parquet.org.apache.thrift.protocol;

import org.apache.hudi.shaded.parquet.org.apache.thrift.TException;
import org.apache.hudi.shaded.parquet.org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.hudi.shaded.parquet.org.apache.thrift.protocol.TCompactProtocol;
import org.apache.hudi.shaded.parquet.org.apache.thrift.protocol.TField;
import org.apache.hudi.shaded.parquet.org.apache.thrift.protocol.TJSONProtocol;
import org.apache.hudi.shaded.parquet.org.apache.thrift.protocol.TList;
import org.apache.hudi.shaded.parquet.org.apache.thrift.protocol.TMap;
import org.apache.hudi.shaded.parquet.org.apache.thrift.protocol.TProtocol;
import org.apache.hudi.shaded.parquet.org.apache.thrift.protocol.TProtocolFactory;
import org.apache.hudi.shaded.parquet.org.apache.thrift.protocol.TSet;

public class TProtocolUtil {
    private static int maxSkipDepth = Integer.MAX_VALUE;

    public static void setMaxSkipDepth(int depth) {
        maxSkipDepth = depth;
    }

    public static void skip(TProtocol prot, byte type) throws TException {
        TProtocolUtil.skip(prot, type, maxSkipDepth);
    }

    public static void skip(TProtocol prot, byte type, int maxDepth) throws TException {
        if (maxDepth <= 0) {
            throw new TException("Maximum skip depth exceeded");
        }
        switch (type) {
            case 2: {
                prot.readBool();
                break;
            }
            case 3: {
                prot.readByte();
                break;
            }
            case 6: {
                prot.readI16();
                break;
            }
            case 8: {
                prot.readI32();
                break;
            }
            case 10: {
                prot.readI64();
                break;
            }
            case 4: {
                prot.readDouble();
                break;
            }
            case 11: {
                prot.readBinary();
                break;
            }
            case 12: {
                prot.readStructBegin();
                while (true) {
                    TField field = prot.readFieldBegin();
                    if (field.type == 0) break;
                    TProtocolUtil.skip(prot, field.type, maxDepth - 1);
                    prot.readFieldEnd();
                }
                prot.readStructEnd();
                break;
            }
            case 13: {
                TMap map = prot.readMapBegin();
                for (int i = 0; i < map.size; ++i) {
                    TProtocolUtil.skip(prot, map.keyType, maxDepth - 1);
                    TProtocolUtil.skip(prot, map.valueType, maxDepth - 1);
                }
                prot.readMapEnd();
                break;
            }
            case 14: {
                TSet set = prot.readSetBegin();
                for (int i = 0; i < set.size; ++i) {
                    TProtocolUtil.skip(prot, set.elemType, maxDepth - 1);
                }
                prot.readSetEnd();
                break;
            }
            case 15: {
                TList list = prot.readListBegin();
                for (int i = 0; i < list.size; ++i) {
                    TProtocolUtil.skip(prot, list.elemType, maxDepth - 1);
                }
                prot.readListEnd();
                break;
            }
        }
    }

    public static TProtocolFactory guessProtocolFactory(byte[] data, TProtocolFactory fallback) {
        if (123 == data[0] && 125 == data[data.length - 1]) {
            return new TJSONProtocol.Factory();
        }
        if (data[data.length - 1] != 0) {
            return new TBinaryProtocol.Factory();
        }
        if (data[0] > 16) {
            return new TCompactProtocol.Factory();
        }
        if (data.length > 1 && 0 == data[1]) {
            return new TBinaryProtocol.Factory();
        }
        if (data.length > 1 && (data[1] & 0x80) != 0) {
            return new TCompactProtocol.Factory();
        }
        return fallback;
    }
}

