/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.keygen.BuiltinKeyGenerator;
import org.apache.hudi.keygen.GlobalAvroDeleteKeyGenerator;
import org.apache.hudi.keygen.RowKeyGeneratorHelper;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;

public class GlobalDeleteKeyGenerator
extends BuiltinKeyGenerator {
    private final GlobalAvroDeleteKeyGenerator globalAvroDeleteKeyGenerator;

    public GlobalDeleteKeyGenerator(TypedProperties config) {
        super(config);
        this.recordKeyFields = Arrays.asList(config.getString(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key()).split(","));
        this.globalAvroDeleteKeyGenerator = new GlobalAvroDeleteKeyGenerator(config);
    }

    public String getRecordKey(GenericRecord record) {
        return this.globalAvroDeleteKeyGenerator.getRecordKey(record);
    }

    public String getPartitionPath(GenericRecord record) {
        return this.globalAvroDeleteKeyGenerator.getPartitionPath(record);
    }

    public List<String> getPartitionPathFields() {
        return new ArrayList<String>();
    }

    @Override
    public String getRecordKey(Row row) {
        this.buildFieldSchemaInfoIfNeeded(row.schema());
        return RowKeyGeneratorHelper.getRecordKeyFromRow(row, this.getRecordKeyFields(), this.recordKeySchemaInfo, true);
    }

    @Override
    public String getPartitionPath(Row row) {
        return this.globalAvroDeleteKeyGenerator.getEmptyPartition();
    }

    @Override
    public String getPartitionPath(InternalRow row, StructType structType) {
        return this.globalAvroDeleteKeyGenerator.getEmptyPartition();
    }
}

