/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.keygen.BuiltinKeyGenerator;
import org.apache.hudi.keygen.NonpartitionedAvroKeyGenerator;
import org.apache.hudi.keygen.RowKeyGeneratorHelper;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;

public class NonpartitionedKeyGenerator
extends BuiltinKeyGenerator {
    private final NonpartitionedAvroKeyGenerator nonpartitionedAvroKeyGenerator;

    public NonpartitionedKeyGenerator(TypedProperties props) {
        super(props);
        this.recordKeyFields = Arrays.stream(props.getString(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key()).split(",")).map(String::trim).collect(Collectors.toList());
        this.partitionPathFields = Collections.emptyList();
        this.nonpartitionedAvroKeyGenerator = new NonpartitionedAvroKeyGenerator(props);
    }

    public String getRecordKey(GenericRecord record) {
        return this.nonpartitionedAvroKeyGenerator.getRecordKey(record);
    }

    public String getPartitionPath(GenericRecord record) {
        return this.nonpartitionedAvroKeyGenerator.getPartitionPath(record);
    }

    public List<String> getPartitionPathFields() {
        return this.nonpartitionedAvroKeyGenerator.getPartitionPathFields();
    }

    @Override
    public String getRecordKey(Row row) {
        this.buildFieldSchemaInfoIfNeeded(row.schema());
        return RowKeyGeneratorHelper.getRecordKeyFromRow(row, this.getRecordKeyFields(), this.recordKeySchemaInfo, false);
    }

    @Override
    public String getPartitionPath(Row row) {
        return this.nonpartitionedAvroKeyGenerator.getEmptyPartition();
    }

    @Override
    public String getPartitionPath(InternalRow internalRow, StructType structType) {
        return this.nonpartitionedAvroKeyGenerator.getEmptyPartition();
    }
}

