/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.bootstrap;

import java.io.IOException;
import java.util.Iterator;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieFileStatus;
import org.apache.hudi.client.bootstrap.BootstrapRecordPayload;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.ParquetReaderIterator;
import org.apache.hudi.common.util.queue.BoundedInMemoryExecutor;
import org.apache.hudi.common.util.queue.BoundedInMemoryQueueConsumer;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.io.HoodieBootstrapHandle;
import org.apache.hudi.keygen.KeyGeneratorInterface;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.bootstrap.BaseBootstrapMetadataHandler;
import org.apache.hudi.table.action.bootstrap.BootstrapRecordConsumer;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.parquet.avro.AvroParquetReader;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.MessageType;

class ParquetBootstrapMetadataHandler
extends BaseBootstrapMetadataHandler {
    private static final Logger LOG = LogManager.getLogger(ParquetBootstrapMetadataHandler.class);

    public ParquetBootstrapMetadataHandler(HoodieWriteConfig config, HoodieTable table, HoodieFileStatus srcFileStatus) {
        super(config, table, srcFileStatus);
    }

    @Override
    Schema getAvroSchema(Path sourceFilePath) throws IOException {
        ParquetMetadata readFooter = ParquetFileReader.readFooter((Configuration)this.table.getHadoopConf(), (Path)sourceFilePath, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
        MessageType parquetSchema = readFooter.getFileMetaData().getSchema();
        return new AvroSchemaConverter().convert(parquetSchema);
    }

    @Override
    void executeBootstrap(HoodieBootstrapHandle<?, ?, ?, ?> bootstrapHandle, Path sourceFilePath, KeyGeneratorInterface keyGenerator, String partitionPath, Schema avroSchema) throws Exception {
        BoundedInMemoryExecutor wrapper = null;
        ParquetReader reader = AvroParquetReader.builder((Path)sourceFilePath).withConf(this.table.getHadoopConf()).build();
        try {
            wrapper = new BoundedInMemoryExecutor((long)this.config.getWriteBufferLimitBytes(), (Iterator)new ParquetReaderIterator(reader), (BoundedInMemoryQueueConsumer)new BootstrapRecordConsumer(bootstrapHandle), inp -> {
                String recKey = keyGenerator.getKey(inp).getRecordKey();
                GenericData.Record gr = new GenericData.Record(HoodieAvroUtils.RECORD_KEY_SCHEMA);
                gr.put("_hoodie_record_key", (Object)recKey);
                BootstrapRecordPayload payload = new BootstrapRecordPayload((GenericRecord)gr);
                HoodieAvroRecord rec = new HoodieAvroRecord(new HoodieKey(recKey, partitionPath), (HoodieRecordPayload)payload);
                return rec;
            }, this.table.getPreExecuteRunnable());
            wrapper.execute();
        }
        catch (Exception e) {
            throw new HoodieException((Throwable)e);
        }
        finally {
            reader.close();
            if (null != wrapper) {
                wrapper.shutdownNow();
                wrapper.awaitTermination();
            }
            bootstrapHandle.close();
        }
    }
}

