/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact;

import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.compact.HoodieCompactor;

public class HoodieSparkMergeOnReadTableCompactor<T extends HoodieRecordPayload>
extends HoodieCompactor<T, HoodieData<HoodieRecord<T>>, HoodieData<HoodieKey>, HoodieData<WriteStatus>> {
    public void preCompact(HoodieTable table, HoodieTimeline pendingCompactionTimeline, String compactionInstantTime) {
        HoodieInstant instant = HoodieTimeline.getCompactionRequestedInstant((String)compactionInstantTime);
        if (!pendingCompactionTimeline.containsInstant(instant)) {
            throw new IllegalStateException("No Compaction request available at " + compactionInstantTime + " to run compaction");
        }
    }

    public void maybePersist(HoodieData<WriteStatus> writeStatus, HoodieWriteConfig config) {
        writeStatus.persist(config.getString(HoodieWriteConfig.WRITE_STATUS_STORAGE_LEVEL_VALUE));
    }
}

