/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import org.apache.kafka.clients.consumer.internals.AbstractPartitionAssignor;
import org.apache.kafka.common.utils.Utils;
import org.junit.Assert;
import org.junit.Test;

public class AbstractPartitionAssignorTest {
    @Test
    public void testMemberInfoSortingWithoutGroupInstanceId() {
        AbstractPartitionAssignor.MemberInfo m1 = new AbstractPartitionAssignor.MemberInfo("a", Optional.empty());
        AbstractPartitionAssignor.MemberInfo m2 = new AbstractPartitionAssignor.MemberInfo("b", Optional.empty());
        AbstractPartitionAssignor.MemberInfo m3 = new AbstractPartitionAssignor.MemberInfo("c", Optional.empty());
        List<AbstractPartitionAssignor.MemberInfo> memberInfoList = Arrays.asList(m1, m2, m3);
        Assert.assertEquals(memberInfoList, (Object)Utils.sorted(memberInfoList));
    }

    @Test
    public void testMemberInfoSortingWithAllGroupInstanceId() {
        AbstractPartitionAssignor.MemberInfo m1 = new AbstractPartitionAssignor.MemberInfo("a", Optional.of("y"));
        AbstractPartitionAssignor.MemberInfo m2 = new AbstractPartitionAssignor.MemberInfo("b", Optional.of("z"));
        AbstractPartitionAssignor.MemberInfo m3 = new AbstractPartitionAssignor.MemberInfo("c", Optional.of("x"));
        List<AbstractPartitionAssignor.MemberInfo> memberInfoList = Arrays.asList(m1, m2, m3);
        Assert.assertEquals(Arrays.asList(m3, m1, m2), (Object)Utils.sorted(memberInfoList));
    }

    @Test
    public void testMemberInfoSortingSomeGroupInstanceId() {
        AbstractPartitionAssignor.MemberInfo m1 = new AbstractPartitionAssignor.MemberInfo("a", Optional.empty());
        AbstractPartitionAssignor.MemberInfo m2 = new AbstractPartitionAssignor.MemberInfo("b", Optional.of("y"));
        AbstractPartitionAssignor.MemberInfo m3 = new AbstractPartitionAssignor.MemberInfo("c", Optional.of("x"));
        List<AbstractPartitionAssignor.MemberInfo> memberInfoList = Arrays.asList(m1, m2, m3);
        Assert.assertEquals(Arrays.asList(m3, m2, m1), (Object)Utils.sorted(memberInfoList));
    }

    @Test
    public void testMergeSortManyMemberInfo() {
        Random rand = new Random();
        int bound = 2;
        ArrayList<AbstractPartitionAssignor.MemberInfo> memberInfoList = new ArrayList<AbstractPartitionAssignor.MemberInfo>();
        ArrayList<Object> staticMemberList = new ArrayList<Object>();
        ArrayList<AbstractPartitionAssignor.MemberInfo> dynamicMemberList = new ArrayList<AbstractPartitionAssignor.MemberInfo>();
        for (int i = 0; i < 100; ++i) {
            String id = Integer.toString(i + 100);
            Optional<Object> groupInstanceId = rand.nextInt(bound) < bound / 2 ? Optional.of(id) : Optional.empty();
            AbstractPartitionAssignor.MemberInfo m = new AbstractPartitionAssignor.MemberInfo(id, groupInstanceId);
            memberInfoList.add(m);
            if (m.groupInstanceId.isPresent()) {
                staticMemberList.add(m);
                continue;
            }
            dynamicMemberList.add(m);
        }
        staticMemberList.addAll(dynamicMemberList);
        Collections.shuffle(memberInfoList);
        Assert.assertEquals(staticMemberList, (Object)Utils.sorted(memberInfoList));
    }
}

