/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.sasl.SaslException;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.auth.SaslExtensions;
import org.apache.kafka.common.security.auth.SaslExtensionsCallback;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;
import org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerClientInitialResponse;
import org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerSaslClient;
import org.junit.Assert;
import org.junit.Test;

public class OAuthBearerSaslClientTest {
    private static final Map<String, String> TEST_PROPERTIES = new LinkedHashMap<String, String>(){
        {
            this.put("One", "1");
            this.put("Two", "2");
            this.put("Three", "3");
        }
    };
    private SaslExtensions testExtensions = new SaslExtensions(TEST_PROPERTIES);
    private final String errorMessage = "Error as expected!";

    @Test
    public void testAttachesExtensionsToFirstClientMessage() throws Exception {
        String expectedToken = new String(new OAuthBearerClientInitialResponse("", this.testExtensions).toBytes(), StandardCharsets.UTF_8);
        OAuthBearerSaslClient client = new OAuthBearerSaslClient((AuthenticateCallbackHandler)new ExtensionsCallbackHandler(false));
        String message = new String(client.evaluateChallenge("".getBytes()), StandardCharsets.UTF_8);
        Assert.assertEquals((Object)expectedToken, (Object)message);
    }

    @Test
    public void testNoExtensionsDoesNotAttachAnythingToFirstClientMessage() throws Exception {
        TEST_PROPERTIES.clear();
        this.testExtensions = new SaslExtensions(TEST_PROPERTIES);
        String expectedToken = new String(new OAuthBearerClientInitialResponse("", new SaslExtensions(TEST_PROPERTIES)).toBytes(), StandardCharsets.UTF_8);
        OAuthBearerSaslClient client = new OAuthBearerSaslClient((AuthenticateCallbackHandler)new ExtensionsCallbackHandler(false));
        String message = new String(client.evaluateChallenge("".getBytes()), StandardCharsets.UTF_8);
        Assert.assertEquals((Object)expectedToken, (Object)message);
    }

    @Test
    public void testWrapsExtensionsCallbackHandlingErrorInSaslExceptionInFirstClientMessage() {
        OAuthBearerSaslClient client = new OAuthBearerSaslClient((AuthenticateCallbackHandler)new ExtensionsCallbackHandler(true));
        try {
            client.evaluateChallenge("".getBytes());
            Assert.fail((String)("Should have failed with " + SaslException.class.getName()));
        }
        catch (SaslException e) {
            Assert.assertEquals(ConfigException.class, e.getCause().getClass());
            Assert.assertEquals((Object)"Error as expected!", (Object)e.getCause().getMessage());
        }
    }

    public class ExtensionsCallbackHandler
    implements AuthenticateCallbackHandler {
        private boolean configured = false;
        private boolean toThrow;

        ExtensionsCallbackHandler(boolean toThrow) {
            this.toThrow = toThrow;
        }

        public boolean configured() {
            return this.configured;
        }

        public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
            this.configured = true;
        }

        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof OAuthBearerTokenCallback) {
                    ((OAuthBearerTokenCallback)callback).token(new OAuthBearerToken(){

                        public String value() {
                            return "";
                        }

                        public Set<String> scope() {
                            return Collections.emptySet();
                        }

                        public long lifetimeMs() {
                            return 100L;
                        }

                        public String principalName() {
                            return "principalName";
                        }

                        public Long startTimeMs() {
                            return null;
                        }
                    });
                    continue;
                }
                if (callback instanceof SaslExtensionsCallback) {
                    if (this.toThrow) {
                        throw new ConfigException("Error as expected!");
                    }
                    ((SaslExtensionsCallback)callback).extensions(OAuthBearerSaslClientTest.this.testExtensions);
                    continue;
                }
                throw new UnsupportedCallbackException(callback);
            }
        }

        public void close() {
        }
    }
}

