/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.util.Constants;

public class OutputStreamManager
extends AbstractManager
implements ByteBufferDestination {
    protected final Layout<?> layout;
    protected ByteBuffer byteBuffer;
    private volatile OutputStream os;
    private boolean skipFooter = false;

    protected OutputStreamManager(OutputStream os, String streamName, Layout<?> layout, boolean writeHeader) {
        this(os, streamName, layout, writeHeader, ByteBuffer.wrap(new byte[Constants.ENCODER_BYTE_BUFFER_SIZE]));
    }

    protected OutputStreamManager(OutputStream os, String streamName, Layout<?> layout, boolean writeHeader, ByteBuffer byteBuffer) {
        super(streamName);
        byte[] header;
        this.os = os;
        this.layout = layout;
        if (writeHeader && layout != null && (header = layout.getHeader()) != null) {
            try {
                this.os.write(header, 0, header.length);
            }
            catch (IOException e) {
                this.logError("unable to write header", e);
            }
        }
        this.byteBuffer = Objects.requireNonNull(byteBuffer, "byteBuffer");
    }

    public static <T> OutputStreamManager getManager(String name, T data, ManagerFactory<? extends OutputStreamManager, T> factory) {
        return AbstractManager.getManager(name, factory, data);
    }

    public void skipFooter(boolean skipFooter) {
        this.skipFooter = skipFooter;
    }

    @Override
    public void releaseSub() {
        this.writeFooter();
        this.close();
    }

    protected void writeFooter() {
        if (this.layout == null || this.skipFooter) {
            return;
        }
        byte[] footer = this.layout.getFooter();
        if (footer != null) {
            this.write(footer);
        }
    }

    public boolean isOpen() {
        return this.getCount() > 0;
    }

    protected OutputStream getOutputStream() {
        return this.os;
    }

    protected void setOutputStream(OutputStream os) {
        byte[] header = this.layout.getHeader();
        if (header != null) {
            try {
                os.write(header, 0, header.length);
                this.os = os;
            }
            catch (IOException ioe) {
                this.logError("unable to write header", ioe);
            }
        } else {
            this.os = os;
        }
    }

    protected void write(byte[] bytes) {
        this.write(bytes, 0, bytes.length, false);
    }

    protected void write(byte[] bytes, boolean immediateFlush) {
        this.write(bytes, 0, bytes.length, immediateFlush);
    }

    protected void write(byte[] bytes, int offset, int length) {
        this.write(bytes, offset, length, false);
    }

    protected synchronized void write(byte[] bytes, int offset, int length, boolean immediateFlush) {
        if (immediateFlush && this.byteBuffer.position() == 0) {
            this.writeToDestination(bytes, offset, length);
            this.flushDestination();
            return;
        }
        if (length >= this.byteBuffer.capacity()) {
            this.flush();
            this.writeToDestination(bytes, offset, length);
        } else {
            if (length > this.byteBuffer.remaining()) {
                this.flush();
            }
            this.byteBuffer.put(bytes, offset, length);
        }
        if (immediateFlush) {
            this.flush();
        }
    }

    protected synchronized void writeToDestination(byte[] bytes, int offset, int length) {
        try {
            this.os.write(bytes, offset, length);
        }
        catch (IOException ex) {
            String msg = "Error writing to stream " + this.getName();
            throw new AppenderLoggingException(msg, ex);
        }
    }

    protected synchronized void flushDestination() {
        try {
            this.os.flush();
        }
        catch (IOException ex) {
            String msg = "Error flushing stream " + this.getName();
            throw new AppenderLoggingException(msg, ex);
        }
    }

    protected synchronized void flushBuffer(ByteBuffer buf) {
        buf.flip();
        if (buf.limit() > 0) {
            this.writeToDestination(buf.array(), 0, buf.limit());
        }
        buf.clear();
    }

    public synchronized void flush() {
        this.flushBuffer(this.byteBuffer);
        this.flushDestination();
    }

    protected synchronized void close() {
        this.flush();
        OutputStream stream = this.os;
        if (stream == System.out || stream == System.err) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException ex) {
            this.logError("unable to close stream", ex);
        }
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    @Override
    public ByteBuffer drain(ByteBuffer buf) {
        this.flushBuffer(buf);
        return buf;
    }
}

