/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.logging.log4j.core.appender.rolling.action.AbstractAction;

public class FileRenameAction
extends AbstractAction {
    private final File source;
    private final File destination;
    private final boolean renameEmptyFiles;

    public FileRenameAction(File src, File dst, boolean renameEmptyFiles) {
        this.source = src;
        this.destination = dst;
        this.renameEmptyFiles = renameEmptyFiles;
    }

    @Override
    public boolean execute() {
        return FileRenameAction.execute(this.source, this.destination, this.renameEmptyFiles);
    }

    public File getDestination() {
        return this.destination;
    }

    public File getSource() {
        return this.source;
    }

    public boolean isRenameEmptyFiles() {
        return this.renameEmptyFiles;
    }

    public static boolean execute(File source, File destination, boolean renameEmptyFiles) {
        if (renameEmptyFiles || source.length() > 0L) {
            File parent = destination.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
                if (!parent.exists()) {
                    LOGGER.error("Unable to create directory {}", (Object)parent.getAbsolutePath());
                    return false;
                }
            }
            Path sourcePath = source.toPath();
            try {
                Files.move(sourcePath, destination.toPath(), new CopyOption[0]);
                return true;
            }
            catch (Exception ex) {
                LOGGER.error("Unable to rename {} to {} due to {} - {}", (Object)source.toString(), (Object)destination.toString(), (Object)ex.getClass().getSimpleName(), (Object)ex.getMessage());
                try {
                    Files.copy(sourcePath, destination.toPath(), new CopyOption[0]);
                    Files.delete(sourcePath);
                    return true;
                }
                catch (Exception iex) {
                    LOGGER.error("Unable to rename file {} to {} due to {} - {}", (Object)source.getAbsolutePath(), (Object)destination.getAbsolutePath(), (Object)iex.getClass().getSimpleName(), (Object)iex.getMessage());
                }
            }
        } else {
            try {
                Files.delete(source.toPath());
            }
            catch (Exception ex) {
                LOGGER.error("Unable to delete empty file " + source.getAbsolutePath());
            }
        }
        return false;
    }

    public String toString() {
        return FileRenameAction.class.getSimpleName() + '[' + this.source + " to " + this.destination + ", renameEmptyFiles=" + this.renameEmptyFiles + ']';
    }
}

