/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public enum Authority {
    ROLE_MONITOR,
    ROLE_DFM,
    ROLE_ADMIN,
    ROLE_PROVENANCE,
    ROLE_PROXY,
    ROLE_NIFI;


    public static Authority valueOfAuthority(String rawAuthority) {
        Authority desiredAuthority = null;
        for (Authority authority : Authority.values()) {
            if (!authority.toString().equals(rawAuthority)) continue;
            desiredAuthority = authority;
            break;
        }
        return desiredAuthority;
    }

    public static Set<String> getRawAuthorities() {
        LinkedHashSet<String> authorities = new LinkedHashSet<String>();
        for (Authority authority : Authority.values()) {
            authorities.add(authority.toString());
        }
        return authorities;
    }

    public static Set<String> convertAuthorities(Set<Authority> authorities) {
        if (authorities == null) {
            throw new IllegalArgumentException("No authorities have been specified.");
        }
        HashSet<String> rawAuthorities = new HashSet<String>(authorities.size());
        for (Authority authority : authorities) {
            rawAuthorities.add(authority.toString());
        }
        return rawAuthorities;
    }

    public static EnumSet<Authority> convertRawAuthorities(Set<String> rawAuthorities) {
        if (rawAuthorities == null) {
            throw new IllegalArgumentException("No authorities have been specified.");
        }
        EnumSet<Authority> authorities = EnumSet.noneOf(Authority.class);
        for (String rawAuthority : rawAuthorities) {
            Authority authority = Authority.valueOfAuthority(rawAuthority);
            if (authority == null) continue;
            authorities.add(authority);
        }
        return authorities;
    }
}

