/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.components;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.controller.ControllerService;

public final class PropertyDescriptor
implements Comparable<PropertyDescriptor> {
    public static final PropertyDescriptor NULL_DESCRIPTOR = new Builder().name("").build();
    private final String name;
    private final String displayName;
    private final String description;
    private final String defaultValue;
    private final List<AllowableValue> allowableValues;
    private final boolean required;
    private final boolean sensitive;
    private final boolean dynamic;
    private final boolean expressionLanguageSupported;
    private final Class<? extends ControllerService> controllerServiceDefinition;
    private final List<Validator> validators;

    protected PropertyDescriptor(Builder builder) {
        this.displayName = builder.displayName == null ? builder.name : builder.displayName;
        this.name = builder.name;
        this.description = builder.description;
        this.defaultValue = builder.defaultValue;
        this.allowableValues = builder.allowableValues;
        this.required = builder.required;
        this.sensitive = builder.sensitive;
        this.dynamic = builder.dynamic;
        this.expressionLanguageSupported = builder.expressionLanguageSupported;
        this.controllerServiceDefinition = builder.controllerServiceDefinition;
        this.validators = new ArrayList<Validator>(builder.validators);
    }

    @Override
    public int compareTo(PropertyDescriptor o) {
        if (o == null) {
            return -1;
        }
        return this.getName().compareTo(o.getName());
    }

    public ValidationResult validate(String input, ValidationContext context) {
        Validator validator;
        ValidationResult lastResult = Validator.INVALID.validate(this.name, input, context);
        if (this.allowableValues != null && !this.allowableValues.isEmpty()) {
            ConstrainedSetValidator csValidator = new ConstrainedSetValidator(this.allowableValues);
            ValidationResult csResult = csValidator.validate(this.name, input, context);
            if (csResult.isValid()) {
                lastResult = csResult;
            } else {
                return csResult;
            }
        }
        if (this.controllerServiceDefinition != null) {
            Set<String> validIdentifiers = context.getControllerServiceLookup().getControllerServiceIdentifiers(this.controllerServiceDefinition);
            if (validIdentifiers != null && validIdentifiers.contains(input)) {
                ControllerService controllerService = context.getControllerServiceLookup().getControllerService(input);
                if (!context.isValidationRequired(controllerService)) {
                    return new ValidationResult.Builder().input(input).subject(this.getName()).valid(true).build();
                }
                String serviceId = controllerService.getIdentifier();
                if (!this.isDependentServiceEnableable(context, serviceId)) {
                    return new ValidationResult.Builder().input(context.getControllerServiceLookup().getControllerServiceName(serviceId)).subject(this.getName()).valid(false).explanation("Controller Service " + controllerService + " is disabled").build();
                }
                Collection<ValidationResult> validationResults = controllerService.validate(context.getControllerServiceValidationContext(controllerService));
                ArrayList<ValidationResult> invalidResults = new ArrayList<ValidationResult>();
                for (ValidationResult result : validationResults) {
                    if (result.isValid()) continue;
                    invalidResults.add(result);
                }
                if (!invalidResults.isEmpty()) {
                    return new ValidationResult.Builder().input(input).subject(this.getName()).valid(false).explanation("Controller Service is not valid: " + (invalidResults.size() > 1 ? invalidResults : invalidResults.get(0))).build();
                }
                return new ValidationResult.Builder().input(input).subject(this.getName()).valid(true).build();
            }
            return new ValidationResult.Builder().input(input).subject(this.getName()).valid(false).explanation("Invalid Controller Service: " + input + " is not a valid Controller Service Identifier or does not reference the correct type of Controller Service").build();
        }
        Iterator<Validator> iterator = this.validators.iterator();
        while (iterator.hasNext() && (lastResult = (validator = iterator.next()).validate(this.name, input, context)).isValid()) {
        }
        return lastResult;
    }

    private boolean isDependentServiceEnableable(ValidationContext context, String serviceId) {
        boolean enableable = context.getControllerServiceLookup().isControllerServiceEnabling(serviceId);
        if (!enableable) {
            enableable = context.getControllerServiceLookup().isControllerServiceEnabled(serviceId);
        }
        return enableable;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isSensitive() {
        return this.sensitive;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public boolean isExpressionLanguageSupported() {
        return this.expressionLanguageSupported;
    }

    public Class<? extends ControllerService> getControllerServiceDefinition() {
        return this.controllerServiceDefinition;
    }

    public List<Validator> getValidators() {
        return Collections.unmodifiableList(this.validators);
    }

    public List<AllowableValue> getAllowableValues() {
        return this.allowableValues == null ? null : Collections.unmodifiableList(this.allowableValues);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof PropertyDescriptor)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        PropertyDescriptor desc = (PropertyDescriptor)other;
        return this.name.equals(desc.name);
    }

    public int hashCode() {
        return 287 + this.name.hashCode() * 47;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.displayName + "]";
    }

    private static final class ConstrainedSetValidator
    implements Validator {
        private static final String POSITIVE_EXPLANATION = "Given value found in allowed set";
        private static final String NEGATIVE_EXPLANATION = "Given value not found in allowed set '%1$s'";
        private static final String VALUE_DEMARCATOR = ", ";
        private final String validStrings;
        private final Collection<String> validValues;

        private ConstrainedSetValidator(Collection<AllowableValue> validValues) {
            String validVals = "";
            if (!validValues.isEmpty()) {
                StringBuilder valuesBuilder = new StringBuilder();
                for (AllowableValue value : validValues) {
                    valuesBuilder.append(value).append(VALUE_DEMARCATOR);
                }
                validVals = valuesBuilder.substring(0, valuesBuilder.length() - VALUE_DEMARCATOR.length());
            }
            this.validStrings = validVals;
            this.validValues = new ArrayList<String>(validValues.size());
            for (AllowableValue value : validValues) {
                this.validValues.add(value.getValue());
            }
        }

        @Override
        public ValidationResult validate(String subject, String input, ValidationContext context) {
            ValidationResult.Builder builder = new ValidationResult.Builder();
            builder.input(input);
            builder.subject(subject);
            if (this.validValues.contains(input)) {
                builder.valid(true);
                builder.explanation(POSITIVE_EXPLANATION);
            } else {
                builder.valid(false);
                builder.explanation(String.format(NEGATIVE_EXPLANATION, this.validStrings));
            }
            return builder.build();
        }
    }

    public static final class Builder {
        private String displayName = null;
        private String name = null;
        private String description = "";
        private String defaultValue = null;
        private List<AllowableValue> allowableValues = null;
        private boolean required = false;
        private boolean sensitive = false;
        private boolean expressionLanguageSupported = false;
        private boolean dynamic = false;
        private Class<? extends ControllerService> controllerServiceDefinition;
        private List<Validator> validators = new ArrayList<Validator>();

        public Builder fromPropertyDescriptor(PropertyDescriptor specDescriptor) {
            this.name = specDescriptor.name;
            this.displayName = specDescriptor.displayName;
            this.description = specDescriptor.description;
            this.defaultValue = specDescriptor.defaultValue;
            this.allowableValues = specDescriptor.allowableValues == null ? null : new ArrayList(specDescriptor.allowableValues);
            this.required = specDescriptor.required;
            this.sensitive = specDescriptor.sensitive;
            this.dynamic = specDescriptor.dynamic;
            this.expressionLanguageSupported = specDescriptor.expressionLanguageSupported;
            this.controllerServiceDefinition = specDescriptor.getControllerServiceDefinition();
            this.validators = new ArrayList<Validator>(specDescriptor.validators);
            return this;
        }

        public Builder displayName(String displayName) {
            if (null != displayName) {
                this.displayName = displayName;
            }
            return this;
        }

        public Builder name(String name) {
            if (null != name) {
                this.name = name;
            }
            return this;
        }

        public Builder expressionLanguageSupported(boolean supported) {
            this.expressionLanguageSupported = supported;
            return this;
        }

        public Builder description(String description) {
            if (null != description) {
                this.description = description;
            }
            return this;
        }

        public Builder defaultValue(String value) {
            if (null != value) {
                this.defaultValue = value;
            }
            return this;
        }

        public Builder dynamic(boolean dynamic) {
            this.dynamic = dynamic;
            return this;
        }

        public Builder allowableValues(Set<String> values) {
            if (null != values) {
                this.allowableValues = new ArrayList<AllowableValue>();
                for (String value : values) {
                    this.allowableValues.add(new AllowableValue(value, value));
                }
            }
            return this;
        }

        public <E extends Enum<E>> Builder allowableValues(E[] values) {
            if (null != values) {
                this.allowableValues = new ArrayList<AllowableValue>();
                for (E value : values) {
                    this.allowableValues.add(new AllowableValue(((Enum)value).name(), ((Enum)value).name()));
                }
            }
            return this;
        }

        public Builder allowableValues(String ... values) {
            if (null != values) {
                this.allowableValues = new ArrayList<AllowableValue>();
                for (String value : values) {
                    this.allowableValues.add(new AllowableValue(value, value));
                }
            }
            return this;
        }

        public Builder allowableValues(AllowableValue ... values) {
            if (null != values) {
                this.allowableValues = Arrays.asList(values);
            }
            return this;
        }

        public Builder required(boolean required) {
            this.required = required;
            return this;
        }

        public Builder sensitive(boolean sensitive) {
            this.sensitive = sensitive;
            return this;
        }

        public Builder addValidator(Validator validator) {
            if (validator != null) {
                this.validators.add(validator);
            }
            return this;
        }

        public Builder identifiesControllerService(Class<? extends ControllerService> controllerServiceDefinition) {
            if (controllerServiceDefinition != null) {
                this.controllerServiceDefinition = controllerServiceDefinition;
            }
            return this;
        }

        private boolean isValueAllowed(String value) {
            if (this.allowableValues == null || value == null) {
                return true;
            }
            for (AllowableValue allowableValue : this.allowableValues) {
                if (!allowableValue.getValue().equals(value)) continue;
                return true;
            }
            return false;
        }

        public PropertyDescriptor build() {
            if (this.name == null) {
                throw new IllegalStateException("Must specify a name");
            }
            if (!this.isValueAllowed(this.defaultValue)) {
                throw new IllegalStateException("Default value [" + this.defaultValue + "] is not in the set of allowable values");
            }
            return new PropertyDescriptor(this);
        }
    }
}

