/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.util.Map;
import org.apache.nifi.components.AbstractConfigurableComponent;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceInitializationContext;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.annotation.OnConfigured;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.reporting.InitializationException;

public abstract class AbstractControllerService
extends AbstractConfigurableComponent
implements ControllerService {
    private String identifier;
    private ControllerServiceLookup serviceLookup;
    private volatile ConfigurationContext configContext;
    private ComponentLog logger;
    private StateManager stateManager;

    @Override
    public final void initialize(ControllerServiceInitializationContext context) throws InitializationException {
        this.identifier = context.getIdentifier();
        this.serviceLookup = context.getControllerServiceLookup();
        this.logger = context.getLogger();
        this.stateManager = context.getStateManager();
        this.init(context);
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @OnConfigured
    public void onConfigurationChange(ConfigurationContext context) {
        this.configContext = context;
    }

    protected final PropertyValue getProperty(PropertyDescriptor descriptor) {
        return this.configContext.getProperty(descriptor);
    }

    protected final Map<PropertyDescriptor, String> getProperties() {
        return this.configContext.getProperties();
    }

    protected final ControllerServiceLookup getControllerServiceLookup() {
        return this.serviceLookup;
    }

    protected void init(ControllerServiceInitializationContext config) throws InitializationException {
    }

    protected ComponentLog getLogger() {
        return this.logger;
    }

    protected StateManager getStateManager() {
        return this.stateManager;
    }
}

