/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status;

import java.util.concurrent.TimeUnit;
import org.apache.nifi.controller.status.RunStatus;

public class ProcessorStatus
implements Cloneable {
    private String id;
    private String groupId;
    private String name;
    private String type;
    private RunStatus runStatus;
    private int inputCount;
    private long inputBytes;
    private int outputCount;
    private long outputBytes;
    private long bytesRead;
    private long bytesWritten;
    private int invocations;
    private long processingNanos;
    private int flowFilesRemoved;
    private long averageLineageDuration;
    private int activeThreadCount;
    private int flowFilesReceived;
    private long bytesReceived;
    private int flowFilesSent;
    private long bytesSent;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getInputCount() {
        return this.inputCount;
    }

    public RunStatus getRunStatus() {
        return this.runStatus;
    }

    public void setRunStatus(RunStatus runStatus) {
        this.runStatus = runStatus;
    }

    public void setInputCount(int inputCount) {
        this.inputCount = inputCount;
    }

    public long getInputBytes() {
        return this.inputBytes;
    }

    public void setInputBytes(long inputBytes) {
        this.inputBytes = inputBytes;
    }

    public int getOutputCount() {
        return this.outputCount;
    }

    public void setOutputCount(int outputCount) {
        this.outputCount = outputCount;
    }

    public long getOutputBytes() {
        return this.outputBytes;
    }

    public void setOutputBytes(long outputBytes) {
        this.outputBytes = outputBytes;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public void setBytesRead(long bytesRead) {
        this.bytesRead = bytesRead;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public void setBytesWritten(long bytesWritten) {
        this.bytesWritten = bytesWritten;
    }

    public int getInvocations() {
        return this.invocations;
    }

    public void setInvocations(int invocations) {
        this.invocations = invocations;
    }

    public long getProcessingNanos() {
        return this.processingNanos;
    }

    public void setProcessingNanos(long processingNanos) {
        this.processingNanos = processingNanos;
    }

    public long getAverageLineageDuration(TimeUnit timeUnit) {
        return TimeUnit.MILLISECONDS.convert(this.averageLineageDuration, timeUnit);
    }

    public void setAverageLineageDuration(long duration, TimeUnit timeUnit) {
        this.averageLineageDuration = timeUnit.toMillis(duration);
    }

    public long getAverageLineageDuration() {
        return this.averageLineageDuration;
    }

    public void setAverageLineageDuration(long millis) {
        this.averageLineageDuration = millis;
    }

    public int getFlowFilesRemoved() {
        return this.flowFilesRemoved;
    }

    public void setFlowFilesRemoved(int flowFilesRemoved) {
        this.flowFilesRemoved = flowFilesRemoved;
    }

    public int getActiveThreadCount() {
        return this.activeThreadCount;
    }

    public void setActiveThreadCount(int activeThreadCount) {
        this.activeThreadCount = activeThreadCount;
    }

    public int getFlowFilesReceived() {
        return this.flowFilesReceived;
    }

    public void setFlowFilesReceived(int flowFilesReceived) {
        this.flowFilesReceived = flowFilesReceived;
    }

    public long getBytesReceived() {
        return this.bytesReceived;
    }

    public void setBytesReceived(long bytesReceived) {
        this.bytesReceived = bytesReceived;
    }

    public int getFlowFilesSent() {
        return this.flowFilesSent;
    }

    public void setFlowFilesSent(int flowFilesSent) {
        this.flowFilesSent = flowFilesSent;
    }

    public long getBytesSent() {
        return this.bytesSent;
    }

    public void setBytesSent(long bytesSent) {
        this.bytesSent = bytesSent;
    }

    public ProcessorStatus clone() {
        ProcessorStatus clonedObj = new ProcessorStatus();
        clonedObj.activeThreadCount = this.activeThreadCount;
        clonedObj.bytesRead = this.bytesRead;
        clonedObj.bytesWritten = this.bytesWritten;
        clonedObj.flowFilesReceived = this.flowFilesReceived;
        clonedObj.bytesReceived = this.bytesReceived;
        clonedObj.flowFilesSent = this.flowFilesSent;
        clonedObj.bytesSent = this.bytesSent;
        clonedObj.groupId = this.groupId;
        clonedObj.id = this.id;
        clonedObj.inputBytes = this.inputBytes;
        clonedObj.inputCount = this.inputCount;
        clonedObj.invocations = this.invocations;
        clonedObj.name = this.name;
        clonedObj.outputBytes = this.outputBytes;
        clonedObj.outputCount = this.outputCount;
        clonedObj.processingNanos = this.processingNanos;
        clonedObj.averageLineageDuration = this.averageLineageDuration;
        clonedObj.flowFilesRemoved = this.flowFilesRemoved;
        clonedObj.runStatus = this.runStatus;
        clonedObj.type = this.type;
        return clonedObj;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ProcessorStatus [id=");
        builder.append(this.id);
        builder.append(", groupId=");
        builder.append(this.groupId);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", type=");
        builder.append(this.type);
        builder.append(", runStatus=");
        builder.append((Object)this.runStatus);
        builder.append(", inputCount=");
        builder.append(this.inputCount);
        builder.append(", inputBytes=");
        builder.append(this.inputBytes);
        builder.append(", outputCount=");
        builder.append(this.outputCount);
        builder.append(", outputBytes=");
        builder.append(this.outputBytes);
        builder.append(", bytesRead=");
        builder.append(this.bytesRead);
        builder.append(", bytesWritten=");
        builder.append(this.bytesWritten);
        builder.append(", invocations=");
        builder.append(this.invocations);
        builder.append(", processingNanos=");
        builder.append(this.processingNanos);
        builder.append(", activeThreadCount=");
        builder.append(this.activeThreadCount);
        builder.append("]");
        return builder.toString();
    }
}

