/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.controller.status.TransmissionStatus;

public class RemoteProcessGroupStatus
implements Cloneable {
    private String id;
    private String groupId;
    private TransmissionStatus transmissionStatus;
    private String uri;
    private String name;
    private Integer activeThreadCount;
    private int sentCount;
    private long sentContentSize;
    private int receivedCount;
    private long receivedContentSize;
    private Integer activeRemotePortCount;
    private Integer inactiveRemotePortCount;
    private long averageLineageDuration;
    private List<String> authorizationIssues = new ArrayList<String>();

    public String getTargetUri() {
        return this.uri;
    }

    public void setTargetUri(String uri) {
        this.uri = uri;
    }

    public TransmissionStatus getTransmissionStatus() {
        return this.transmissionStatus;
    }

    public void setTransmissionStatus(TransmissionStatus transmissionStatus) {
        this.transmissionStatus = transmissionStatus;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getActiveThreadCount() {
        return this.activeThreadCount;
    }

    public void setActiveThreadCount(Integer activeThreadCount) {
        this.activeThreadCount = activeThreadCount;
    }

    public Integer getSentCount() {
        return this.sentCount;
    }

    public void setSentCount(Integer sentCount) {
        this.sentCount = sentCount;
    }

    public Long getSentContentSize() {
        return this.sentContentSize;
    }

    public void setSentContentSize(Long sentContentSize) {
        this.sentContentSize = sentContentSize;
    }

    public Integer getReceivedCount() {
        return this.receivedCount;
    }

    public void setReceivedCount(Integer receivedCount) {
        this.receivedCount = receivedCount;
    }

    public Long getReceivedContentSize() {
        return this.receivedContentSize;
    }

    public void setReceivedContentSize(Long receivedContentSize) {
        this.receivedContentSize = receivedContentSize;
    }

    public Integer getActiveRemotePortCount() {
        return this.activeRemotePortCount;
    }

    public void setActiveRemotePortCount(Integer activeRemotePortCount) {
        this.activeRemotePortCount = activeRemotePortCount;
    }

    public Integer getInactiveRemotePortCount() {
        return this.inactiveRemotePortCount;
    }

    public void setInactiveRemotePortCount(Integer inactiveRemotePortCount) {
        this.inactiveRemotePortCount = inactiveRemotePortCount;
    }

    public List<String> getAuthorizationIssues() {
        return new ArrayList<String>(this.authorizationIssues);
    }

    public void setAuthorizationIssues(List<String> authorizationIssues) {
        this.authorizationIssues = new ArrayList<String>((Collection)Objects.requireNonNull(authorizationIssues));
    }

    public long getAverageLineageDuration() {
        return this.averageLineageDuration;
    }

    public void setAverageLineageDuration(long millis) {
        this.averageLineageDuration = millis;
    }

    public long getAverageLineageDuration(TimeUnit timeUnit) {
        return TimeUnit.MILLISECONDS.convert(this.averageLineageDuration, timeUnit);
    }

    public void setAverageLineageDuration(long duration, TimeUnit timeUnit) {
        this.averageLineageDuration = timeUnit.toMillis(duration);
    }

    public RemoteProcessGroupStatus clone() {
        RemoteProcessGroupStatus clonedObj = new RemoteProcessGroupStatus();
        clonedObj.id = this.id;
        clonedObj.groupId = this.groupId;
        clonedObj.name = this.name;
        clonedObj.uri = this.uri;
        clonedObj.activeThreadCount = this.activeThreadCount;
        clonedObj.transmissionStatus = this.transmissionStatus;
        clonedObj.sentCount = this.sentCount;
        clonedObj.sentContentSize = this.sentContentSize;
        clonedObj.receivedCount = this.receivedCount;
        clonedObj.receivedContentSize = this.receivedContentSize;
        clonedObj.activeRemotePortCount = this.activeRemotePortCount;
        clonedObj.inactiveRemotePortCount = this.inactiveRemotePortCount;
        clonedObj.averageLineageDuration = this.averageLineageDuration;
        clonedObj.authorizationIssues = this.getAuthorizationIssues();
        return clonedObj;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RemoteProcessGroupStatus [id=");
        builder.append(this.id);
        builder.append(", groupId=");
        builder.append(this.groupId);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", uri=");
        builder.append(this.uri);
        builder.append(", activeThreadCount=");
        builder.append(this.activeThreadCount);
        builder.append(", transmissionStatus=");
        builder.append((Object)this.transmissionStatus);
        builder.append(", sentCount=");
        builder.append(this.sentCount);
        builder.append(", sentContentSize=");
        builder.append(this.sentContentSize);
        builder.append(", receivedCount=");
        builder.append(this.receivedCount);
        builder.append(", receivedContentSize=");
        builder.append(this.receivedContentSize);
        builder.append(", activeRemotePortCount=");
        builder.append(this.activeRemotePortCount);
        builder.append(", inactiveRemotePortCount=");
        builder.append(this.inactiveRemotePortCount);
        builder.append(", authenticationIssues=");
        builder.append(this.authorizationIssues);
        builder.append("]");
        return builder.toString();
    }
}

