/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor;

import java.util.Collections;
import java.util.Set;
import org.apache.nifi.annotation.lifecycle.OnConfigurationRestored;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnUnscheduled;
import org.apache.nifi.components.AbstractConfigurableComponent;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.logging.ProcessorLog;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;

public abstract class AbstractSessionFactoryProcessor
extends AbstractConfigurableComponent
implements Processor {
    private String identifier;
    private ProcessorLog logger;
    private volatile boolean scheduled = false;
    private volatile boolean configurationRestored = false;
    private ControllerServiceLookup serviceLookup;
    private String description;

    @Override
    public final void initialize(ProcessorInitializationContext context) {
        this.identifier = context.getIdentifier();
        this.logger = context.getLogger();
        this.serviceLookup = context.getControllerServiceLookup();
        this.init(context);
        this.description = this.getClass().getSimpleName() + "[id=" + this.identifier + "]";
    }

    protected final ControllerServiceLookup getControllerServiceLookup() {
        return this.serviceLookup;
    }

    @Override
    public Set<Relationship> getRelationships() {
        return Collections.emptySet();
    }

    protected final ProcessorLog getLogger() {
        return this.logger;
    }

    protected void init(ProcessorInitializationContext context) {
    }

    protected final boolean isScheduled() {
        return this.scheduled;
    }

    @OnScheduled
    public final void updateScheduledTrue() {
        this.scheduled = true;
    }

    @OnUnscheduled
    public final void updateScheduledFalse() {
        this.scheduled = false;
    }

    @OnConfigurationRestored
    public final void updateConfiguredRestoredTrue() {
        this.configurationRestored = true;
    }

    protected boolean isConfigurationRestored() {
        return this.configurationRestored;
    }

    @Override
    public final String getIdentifier() {
        return this.identifier;
    }

    @Override
    public String toString() {
        return this.description;
    }
}

