/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting;

import java.util.concurrent.TimeUnit;
import org.apache.nifi.components.AbstractConfigurableComponent;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.reporting.ReportingInitializationContext;
import org.apache.nifi.reporting.ReportingTask;

public abstract class AbstractReportingTask
extends AbstractConfigurableComponent
implements ReportingTask {
    private String identifier;
    private String name;
    private long schedulingNanos;
    private ControllerServiceLookup serviceLookup;
    private ComponentLog logger;

    @Override
    public final void initialize(ReportingInitializationContext config) throws InitializationException {
        this.identifier = config.getIdentifier();
        this.logger = config.getLogger();
        this.name = config.getName();
        this.schedulingNanos = config.getSchedulingPeriod(TimeUnit.NANOSECONDS);
        this.serviceLookup = config.getControllerServiceLookup();
        this.init(config);
    }

    protected final ControllerServiceLookup getControllerServiceLookup() {
        return this.serviceLookup;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    protected String getName() {
        return this.name;
    }

    protected long getSchedulingPeriod(TimeUnit timeUnit) {
        return timeUnit.convert(this.schedulingNanos, TimeUnit.NANOSECONDS);
    }

    protected void init(ReportingInitializationContext config) throws InitializationException {
    }

    protected ComponentLog getLogger() {
        return this.logger;
    }
}

