/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.websocket;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.api.WebSocketPingPongListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PingPongHandler
extends WebSocketAdapter
implements WebSocketPingPongListener {
    private static final Logger log = LoggerFactory.getLogger(PingPongHandler.class);

    public void onWebSocketPing(ByteBuffer payload) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("PING: {}", (Object)BufferUtil.toDetailString((ByteBuffer)payload));
            }
            this.getRemote().sendPong(payload);
        }
        catch (IOException e) {
            log.warn("Failed to send pong: {}", (Object)e.getMessage());
        }
    }

    public void onWebSocketPong(ByteBuffer payload) {
    }
}

